/* loadWindowController */

// THIS FILE IS NOW OBSOLETE AS THE LOAD METHOD HAS BEEN CHANGED, A SHEET NO LONGER APPEARS!

import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import java.io.*;

public class loadWindowController extends NSWindowController {

    public NSTextField hexAddress; /* IBOutlet */
    public NSTextField hexAddressLabel; /* IBOutlet */
    public NSButtonCell loadRaw; /* IBOutlet */
    public NSButtonCell loadSaved; /* IBOutlet */
    
    private boolean rawDataState; // true means raw data
    private static loadWindowController _sharedLoadWindowController;
    private static Memory mem;
    private NSOpenPanel op;
    private NSApplication myApp;
    
    loadWindowController() {

        super("Load");
        mem = Memory.sharedMemory();
        rawDataState = false;
        myApp = NSApplication.sharedApplication();        
    }
    
    public void awakeFromNib() {
    
        hexAddressLabel.setTextColor(NSColor.lightGrayColor());

    }
    
    public static void setMemory(Memory newMem) {
    
        mem = newMem;
        
    }
    
    public static loadWindowController sharedLWC() {
    
        if (_sharedLoadWindowController == null)
            _sharedLoadWindowController = new loadWindowController();
        
        return _sharedLoadWindowController;
    }

    public void loadSavedButton(Object sender) { /* IBAction */
        
        //System.out.println("saved");
        rawDataState = false;
        hexAddressLabel.setTextColor(NSColor.lightGrayColor());
        hexAddress.setEnabled(false);
    }
    
    public void loadRawButton(Object sender) { /* IBAction */

        //System.out.println("raw");        
	rawDataState = true;
        hexAddressLabel.setTextColor(NSColor.blackColor());
        hexAddress.setEnabled(true);
    }
    
    public void cancelButton(Object sender) { /* IBAction */
        
        myApp.endSheet(window());
        close();
    }

    public void loadButton(Object sender) { /* IBAction */
    
        myApp.endSheet(window());
        window().orderOut(this);
        close();

        op = NSOpenPanel.openPanel();
        NSMutableArray fileExts = new NSMutableArray();

        int start = hexStringToInt(hexAddress.stringValue());
        
		if (start == -1) {
				// maybe eventually alert here that a bad hex value was entered.
			return;
		}
        
        if (mem == null) {
        
            System.out.println("Memory was not initialized");
            return;
        }
        
        fileExts.addObject("txt");
        op.setAllowsMultipleSelection(false);
        op.beginSheetForDirectory(null, // directory
                                  null, // filename
                                  fileExts,  // file types
                                  MenuController.sharedMenuController().getEmuWindow(), // document window
                                  this, // modalDelegate
                                  new NSSelector("performMemoryLoad::",new Class[] {getClass()}), // didendselector
                                  null); // contextInfo
        
    }
    
    public void performMemoryLoad(NSOpenPanel sheet, int returnCode, Object contextInfo) {
    
        FileInputStream fis = null;
        int start = hexStringToInt(hexAddress.stringValue());
        String fileName;
            
        if (returnCode == NSOpenPanel.OKButton) {
        
            fileName = (String)op.filenames().objectAtIndex(0);
            //System.out.println(fileName);
            
            if (rawDataState == true) { // read in the data starting at specified address
            
                try {
                    fis = new FileInputStream(fileName);
                    int i;
                    int size = fis.available();
                    for (i = start; i < (start + size); i++) {
                        mem.write(i, fis.read());
                    }
                    fis.close();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            
                
            } // raw checked
            else if (rawDataState == false) {
            
                // Load Sim 6502 file
                try {
                    int i, address, value;
                    String _address, _value, _strLine;
                    fis = new FileInputStream(fileName);
                    
                    BufferedReader _br = new BufferedReader(new InputStreamReader(fis));
 
                    
                                                         
                    while ( true ) {	// empty string, last line
                        
                        _strLine = _br.readLine();
                        if (_strLine == null) // last line, exit loop
                            break;
                    
                        System.out.println(_strLine);
                        
                        // skip blank line or comment
                        if (_strLine.length() == 0 || _strLine.charAt(0) == '/')
                            continue;
                        
                        // Get the address from the string
                        _address = _strLine.substring(0, 4);
                        address = hexStringToInt(_address);
                        if (address == -1) // Wrong Address
                            continue;
                            
                        for (i = 6; i < _strLine.length(); i += 3) {
                        
                            _value = _strLine.substring(i,i + 2);
                            value = hexStringToInt(_value);
                            
                            if (value == -1) // Wrong value, get newLine
                                break;
                                
                            // Good value, put it in Memory
                            mem.write((address + 
                                    ((i - 6) / 3)), value);
                        }
                        
                        // read the next line
                       // _strLine = _br.readLine();
                        
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                }

            } // raw not checked
        
            close(); // closes the intermediate window.
            
        } // NSOpenPanel.OKButton
        else if (returnCode == NSOpenPanel.CancelButton) {
        
            System.out.println("NSOpenPanel.CancelButton");
        
        }
    
    }

    public void textChange(Object sender) {/* IBAction */
    }

    // *********************************************
    // ************* Utility Fonctions *************
    // *********************************************

    /**
     *  Utility Function : Transform an Hexadecimal String to an Int <BR>
     * 0xFFFF is the maximum value <BR>
     * return -1 on error
     *
     * @param  s  Hexadecimal String
     * @return    The Int value of the String 
     */
    private int hexStringToInt(String s) {
	//return -1 if s wrong
	int i;
	//return -1 if s wrong
	int j;
	int max = 4;
	int total = 0;
	int p = 0;
	char[] schar = new char[4];
	//get valids Characters
	if (s.length() < 4) {
	    max = s.length();
	}
	s.getChars(0, max, schar, 0);

	for (i = 0; i < max; i++) {
	    j = (max - 1) - i;
	    // Left char is the High bit so char inversion
	    if (i == 0) {
		p = 1;
	    }
	    if (i == 1) {
		p = 16;
	    }
	    if (i == 2) {
		p = 16 * 16;
	    }
	    if (i == 3) {
		p = 16 * 16 * 16;
	    }
	    if ((schar[j] == 'F') | (schar[j] == 'f')) {
		total += 15 * p;
		continue;
	    }
	    if ((schar[j] == 'E') | (schar[j] == 'e')) {
		total += 14 * p;
		continue;
	    }
	    if ((schar[j] == 'D') | (schar[j] == 'd')) {
		total += 13 * p;
		continue;
	    }
	    if ((schar[j] == 'C') | (schar[j] == 'c')) {
		total += 12 * p;
		continue;
	    }
	    if ((schar[j] == 'B') | (schar[j] == 'b')) {
		total += 11 * p;
		continue;
	    }
	    if ((schar[j] == 'A') | (schar[j] == 'a')) {
		total += 10 * p;
		continue;
	    }
	    if (schar[j] == '9') {
		total += 9 * p;
		continue;
	    }
	    if (schar[j] == '8') {
		total += 8 * p;
		continue;
	    }
	    if (schar[j] == '7') {
		total += 7 * p;
		continue;
	    }
	    if (schar[j] == '6') {
		total += 6 * p;
		continue;
	    }
	    if (schar[j] == '5') {
		total += 5 * p;
		continue;
	    }
	    if (schar[j] == '4') {
		total += 4 * p;
		continue;
	    }
	    if (schar[j] == '3') {
		total += 3 * p;
		continue;
	    }
	    if (schar[j] == '2') {
		total += 2 * p;
		continue;
	    }
	    if (schar[j] == '1') {
		total += 1 * p;
		continue;
	    }
	    if (schar[j] == '0') {
		continue;
	    }
	    return -1;
	}
	return total;
    }
}
