/*
 * Pia6820.java - Cocoa v 0.1 is a modified version of Pia6820 v 0.5 by:
 * Copyright (C) 2000 VERHILLE Arnaud
 * Part of "Cocoa Pom 1"
 * gist@wanadoo.fr
 * http://www.chez.com/apple1/
 *
 * -- Modified/updated for Cocoa Pom by Joe Crobak (c) 2004--
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */

import java.awt.*;

/**
 *  The Pia6820 is an Interface between the Memory and the outside world
 * In this case the Keyboard, The Terminal, and the Tape Interface.
 *
 * @author     VERHILLE Arnaud 
 * @created    21 octobre 2000 
 * @modified   Joe Crobak 4 January 2004
 */
public class Pia6820 {
    private int dspCr, dsp, kbdCr, kbd;
    private boolean kbdInterrupts, // not quite sure what these are or are used for yet.
        dspOutput;
    private static Pia6820 _pia;
    
	// Constructor
    public Pia6820() {
		reset();
    }

	// sets initial values
	public void reset() {
	    kbdInterrupts = false;
	    kbdCr = 0x00;
	    dspOutput = false;
	    dspCr = 0x00;
	}
    
	// Creates shared instance if necessary and returns this instance
    public static Pia6820 sharedPia6820() {
		if (_pia == null)
            _pia = new Pia6820();            
        return _pia;
    }

    //*****************************************
    //************** Write Methods ************
    //*****************************************

    public void setKbdInterrupts(boolean b) {
		kbdInterrupts = b;
    }
	
	// Write the DSP Control Register
	public void writeDspCr(int dspCr) {
	    if (!dspOutput) {
			if (dspCr >= 0x80) {
				// Enable DSP Output
				dspOutput = true;
			}
			dspCr = 0x00;
	    }
	    else {
			this.dspCr = dspCr;
	    }
	}
	
	// Write the DSP register
    public void writeDsp(int dsp) {
		if (dsp >= 0x80) {
			dsp = dsp - 0x80;
		}
		Screen.sharedScreen().outputDsp(dsp);
		this.dsp = dsp;
    }

	// Write the Keyboard Control Register
    public void writeKbdCr(int kbdCr) {
		if (!getKbdInterrupts()) {
			if (kbdCr >= 0x80) {
				// Enable Keyboard Interrupts, set Call
				setKbdInterrupts(true);
				kbdCr = 0x00;
			}
		}
		else {
			this.kbdCr = kbdCr;
		}
    }

	// write the Keyboard Register
    public void writeKbd(int kbd) {
		this.kbd = kbd;
    }

    //*****************************************
    //************** Read Methods *************
    //*****************************************

    public boolean getKbdInterrupts() {
		return kbdInterrupts;
    }

    public boolean getDspOutput() {
		return dspOutput;
    }
	
	// Read the DSP Control Register
	public int readDspCr() {
	    return dspCr;
	}
	
	// Read the DSP Register
    public int readDsp() {
		return dsp;
    }

	// Read the Keyboard Control Register.
    public int readKbdCr() {
		if (getKbdInterrupts()) {
			if (kbdCr >= 0x80) {
				kbdCr = 0x00;
				return 0xA7;
			}
		}
		return kbdCr;
    }

	// Read the Keyboard Register.
    public int readKbd() {
		return kbd;
    }

}

