/*
 * MySaveSheetController.java Cocoa v 0.1 
 * Part of "Cocoa Pom 1"
 * Copyright (c) 2004 Joe Crobak
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import java.io.*;

/**
 * Handles the callbacks for the save sheet presented that gives the user a choice to save all or a
 * portion of memory.
 *
 * @author     Joe Crobak 
 * @created    6 January 2003
 * @modified   Joe Crobak 7 January 2004
 */
public class MySaveSheetController extends NSWindowController {

    public NSTextField endAddress; /* IBOutlet */
    public NSButtonCell saveAll; /* IBOutlet */
    public NSButtonCell savePortion; /* IBOutlet */
    public NSTextField startAddress; /* IBOutlet */

	private static MySaveSheetController _sharedMySaveSheetController;
	private NSSavePanel sp;
	private boolean fullSave;

	public MySaveSheetController(){
		super("saveSheet");
	}

	public void awakeFromNib() {
		fullSave=false;
	}
	
	public static MySaveSheetController sharedMySaveSheetController() {
		if (_sharedMySaveSheetController == null)
			_sharedMySaveSheetController = new MySaveSheetController();
		return _sharedMySaveSheetController;
	}

    public void cancelButton(Object sender) { /* IBAction */
		NSApplication.sharedApplication().endSheet(window());
		close();
    }

    public void okButton(Object sender) { /* IBAction */
		NSApplication.sharedApplication().endSheet(window());
		window().orderOut(this);
		close();
		
		sp = NSSavePanel.savePanel();
		sp.setCanSelectHiddenExtension(true);
		sp.setExtensionHidden(false);
		sp.setCanCreateDirectories(true);
		sp.beginSheetForDirectory(null, // directory
								  "memory.txt", // filename
								  MenuController.sharedMenuController().getEmuWindow(), // document window
								  this, // modual delegate
								  new NSSelector("performMemorySave::",new Class[] {getClass()}),  // NSSelector
								  null); // contextObject
    }

	public void performMemorySave(NSSavePanel sheet, int returnCode, Object contextInfo) {
	
		String filename = sp.filename();
		
		try {
			FileOutputStream fos = new FileOutputStream(filename);
			PrintStream ps = new PrintStream( fos );		
			Memory mem = Memory.sharedMemory();
			int start, end;
			
			if (fullSave) {
				start = 0;
				end = mem.getMemorySize()*1024-1;
			} else {
				start = Integer.parseInt(startAddress.stringValue().trim(),16);
				end = Integer.parseInt(endAddress.stringValue().trim(),16);
			}
			try {
				for (int i = start; i <= end; i++) {
					if (i % 8 == 0 || i == start)
						ps.print(intToHexString(i,4) + ": ");
					ps.print(intToHexString(mem.read(i),2));
					if (i % 8 == 7 || i == end)
						ps.println();
					else
						ps.print(" ");
				}
			}
			catch (Exception e) {
				ps.print("//could not save to data file.  likely because of an invalid start/finish address");
			}
		}
		catch (Exception e) {
			System.out.println(e);
		}
	}


    public void saveAllButton(Object sender) { /* IBAction */
		fullSave = true;
		//System.out.println("save all button, full save: " + fullSave);
    }

    public void savePortionButton(Object sender) { /* IBAction */
		fullSave = false;
		//System.out.println("save Portion button, full save: " + fullSave);
    }

    public void textActivate(Object sender) { /* IBAction */
		savePortion.setState(NSCell.OnState);
		saveAll.setState(NSCell.OffState);
		fullSave = false;
    }
	
	// Converts an integer to a string, with atleast as many padding 0's to make it of length stringSize
	private String intToHexString(int x, int stringSize) {
	
		String hexVal = Integer.toHexString(x).toUpperCase();
		
		while (hexVal.length() < stringSize)
			hexVal = '0' + hexVal;
	
		return hexVal;
	}
}
