/* MySaveController */

import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import java.io.*;

public class MySaveController extends NSWindowController {

    public NSTextField comment; /* IBOutlet */
    public NSTextField endAddress; /* IBOutlet */
    public NSTextField endAddressLabel; /* IBOutlet */
    public NSButtonCell saveAll; /* IBOutlet */
    public NSButtonCell savePortion; /* IBOutlet */
    public NSTextField startAddress; /* IBOutlet */
    public NSTextField startAddressLabel; /* IBOutlet */

	private static MySaveController _sharedMySaveController;
	private NSSavePanel sp;
	private boolean fullSave;
	
	public MySaveController() {
		super("Save");
	}
	
	public void awakeFromNib() {	
		fullSave=false;	
	}
	
	public static MySaveController sharedMySaveController() {
		if (_sharedMySaveController == null) {
			_sharedMySaveController = new MySaveController();
			System.out.println("Creating MySaveController shared instance");
		}
		return _sharedMySaveController;
	}

	public void cancelButton(Object sender) { /* IBAction */
		NSApplication.sharedApplication().endSheet(window());
		close();
    }

    public void okButton(Object sender) { /* IBAction */
		NSApplication.sharedApplication().endSheet(window());
		window().orderOut(this);
		close();
		
		sp = NSSavePanel.savePanel();
		sp.setCanSelectHiddenExtension(true);
		sp.setExtensionHidden(false);
		sp.setCanCreateDirectories(true);
		sp.beginSheetForDirectory(null, // directory
								  "memory.txt", // filename
								  MenuController.sharedMenuController().getEmuWindow(), // document window
								  this, // modual delegate
								  new NSSelector("performMemorySave::",new Class[] {getClass()})); // NSSelector
    }

	public void performMemorySave(NSSavePanel sheet, int returnCode, Object contextInfo) {
	
		String filename = sp.filename();
		
		try {
			FileOutputStream fos = new FileOutputStream(filename);
			PrintStream ps = new PrintStream( fos );
		
			Memory mem = Memory.sharedMemory();
			if (fullSave) {
				for (int i=0; i<mem.getMemorySize()*1024; i++) {
					if (i % 8 == 0)
						ps.print(Integer.toHexString(i) + ": ");
					ps.print(mem.read(i));
					if (i % 8 == 7)
						ps.println();
					else
						ps.print(" ");
				}
			}
		}
		catch (Exception e) {
			System.out.println(e);
		}
	}

    public void saveAllButton(Object sender) { /* IBAction */
		fullSave = true;
    }

    public void savePortionButton(Object sender) { /* IBAction */
		fullSave = false;
    }

    public void textActivate(Object sender) { /* IBAction */
		savePortion.setEnabled(true);
		saveAll.setEnabled(false);
    }

}
