/* 
 * MyPrefsController.java Cocoa v 0.1
 * Part of "Cocoa Pom 1"
 * Copyright (c) 2004 Joe Crobak
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

import com.apple.cocoa.foundation.*;
import com.apple.cocoa.application.*;
import java.io.*;

/**
 * This Class handles callbacks from the Preferences Dialog actions.  It also contains the code to load
 * and save the preferences information to and from the preferences file.
 *
 * @author     Joe Crobak 
 * @created    21 December 2003
 * @modified   Joe Crobak 7 January 2004
 */
public class MyPrefsController extends NSWindowController {

    public NSColorWell bgColor; /* IBOutlet */
    public NSPopUpButton memory; /* IBOutlet */
    public NSButton scanline; /* IBOutlet */
    public NSTextField termSpeed; /* IBOutlet */
    public NSColorWell textColor; /* IBOutlet */
    public NSWindow window; /* IBOutlet */
    public NSPopUpButton windowSize; /* IBOutlet */

	private static MyPrefsController _myPrefsController;
	private int oldMemorySize;
	
	public MyPrefsController() {
	
		super();
		_myPrefsController=this;		
	}
		
	public void showWindow(Object sender) {

		if (window == null || window.isVisible() == false) {
			updateDisplay();
			super.showWindow(sender);
		}
		else {
			window.orderFront(sender);
		}
	}
	
	public static MyPrefsController sharedMyPrefsController() {
	
		if (_myPrefsController == null)
			_myPrefsController = new MyPrefsController();
			
		return _myPrefsController;
	}

	// Returns true if a preferences file was found, otherwise it returns false.
	public boolean loadPreferencesFile() {
	
		System.out.println("inside load prefs");
		NSBundle bund = NSBundle.mainBundle();
		String filename = bund.resourcePath() + "/pom1.preferences";
		File file = new File(filename);
		if (!file.exists()) {
			//System.out.println("No preference File exists.");
			return false;
		}
		try {
			FileInputStream fis = new FileInputStream(filename);
			BufferedReader br = new BufferedReader(new InputStreamReader(fis));
						
			// pixelSize
			String line = br.readLine();
			int pixelSize = Integer.parseInt(line);
			Screen.sharedScreen().setPixelSize(pixelSize);

			// scanline
			line = br.readLine();
			System.out.println("Scanline reads: " + line);
			boolean scanln = ((line.charAt(0) == '0') ? false : true);
			System.out.println("Scanln bool: " + scanln);
			Screen.sharedScreen().setScanline(scanln);

			// bgcolor
			line = br.readLine();
			float red = Float.parseFloat(line);
			line = br.readLine();
			float green = Float.parseFloat(line);
			line = br.readLine();
			float blue = Float.parseFloat(line);
			line = br.readLine();
			float alpha = Float.parseFloat(line);
			NSColor bgColor = NSColor.colorWithCalibratedRGB(red,green,blue,alpha);
			Screen.sharedScreen().setBgColor(bgColor);
			
			// text color
			line = br.readLine();
			red = Float.parseFloat(line);
			line = br.readLine();
			green = Float.parseFloat(line);
			line = br.readLine();
			blue = Float.parseFloat(line);
			line = br.readLine();
			alpha = Float.parseFloat(line);
			NSColor textColor = NSColor.colorWithCalibratedRGB(red,green,blue,alpha);
			Screen.sharedScreen().setTextColor(textColor);
			
			// output speed
			line = br.readLine();
			int outputSpeed = Integer.parseInt(line);
			Screen.sharedScreen().setTerminalSpeed(outputSpeed);
			System.out.println("output speed: " + outputSpeed);
			// memory size
			line = br.readLine();
			int memorySize = Integer.parseInt(line);
			System.out.println("Setting memory size to: " + memorySize);
			Memory.sharedMemory().setMemorySize(memorySize);
			Memory.sharedMemory().reset();
			//NSColorWell.color() NSColorWell.setColor()
			
			fis.close();
		}
		catch (Exception e) {
			System.out.println(e + "in loadPrefsFile");
		}
	
		return true;
	}

	public void savePreferencesFile() {
	
		NSBundle bund = NSBundle.mainBundle();
		String filename = bund.resourcePath() + "/pom1.preferences";
			
		try {
			FileOutputStream fos = new FileOutputStream(filename);
			PrintStream ps = new PrintStream( fos );
						
			// pixelSize
			//System.out.println("Pixel Size: " + Screen.sharedScreen().getPixelSize());
			ps.println(Screen.sharedScreen().getPixelSize());

			// scanline
			//System.out.println("Scan line: " + (Screen.sharedScreen().getScanline() ? 1 : 0));
			ps.println( (Screen.sharedScreen().getScanline() ? 1 : 0));
			
			// bgcolor
			NSColor bgColor = Screen.sharedScreen().getBgColor().colorUsingColorSpaceName("NSCalibratedRGBColorSpace");
			ps.println(bgColor.redComponent());
			ps.println(bgColor.greenComponent());
			ps.println(bgColor.blueComponent());
			ps.println(bgColor.alphaComponent());
			//System.out.println("bgColor components: " + bgColor.redComponent() +
			//					bgColor.greenComponent() + bgColor.blueComponent() +
			//					bgColor.alphaComponent());
			
			// text color
			NSColor textColor = Screen.sharedScreen().getTextColor().colorUsingColorSpaceName("NSCalibratedRGBColorSpace");
			ps.println(textColor.redComponent());
			ps.println(textColor.greenComponent());
			ps.println(textColor.blueComponent());
			ps.println(textColor.alphaComponent());
			//System.out.println("textColor components: " + textColor.redComponent() +
			//					textColor.greenComponent() + textColor.blueComponent() +
			//					textColor.alphaComponent());
								
			// output speed
			//System.out.println("term speed: " + Screen.sharedScreen().getTerminalSpeed());
			ps.println(Screen.sharedScreen().getTerminalSpeed());
			
			// memory size
			//System.out.println("mem size: " + Memory.sharedMemory().getMemorySize());
			ps.println(Memory.sharedMemory().getMemorySize());
			
			ps.close();
		}
		catch (Exception e) {
			System.out.println(e);
		}
	}

    public void cancelButton(Object sender) { /* IBAction */
		// discard changes
		close();
    }

    public void defaultsButton(Object sender) { /* IBAction */
		// set back to defaults -- gotta be a better way for defaults

		bgColor.setColor(NSColor.blackColor());
		textColor.setColor(NSColor.greenColor());

		termSpeed.setIntValue(60);
		memory.selectItemWithTitle("64");		
    }

    public void okButton(Object sender) { /* IBAction */
		
		// make sure that if the memory value has changed, that we want to 
		if ( Integer.parseInt(memory.itemTitleAtIndex(memory.indexOfSelectedItem())) != oldMemorySize) {
			//put up a confirmation sheet
			NSAlertPanel.beginAlertSheet(
				"You have changed the memory size which requires a \"hard\" restart.  Do you wish to continue?",
										// sheet message
				"Hard Restart",			// default button
				"Disregard Changes",	// alternate button
				"Cancel",				// other button
				window,					// window attached to
				this,					// modal delegate
				new NSSelector("sheetDidEnd::", new Class[] {getClass()}),
										// did-end selector
				null,					// no did-dismiss selector
				null,					// context info
				"This action cannot be undone.");
										// additional text
			return;
		}

		processChanges();
    }

	public void sheetDidEnd(NSWindow sheet, int returnCode, Object contextInfo) {
	
		switch(returnCode) {
		
			case NSAlertPanel.DefaultReturn: // return button
				processChanges();
				//also need to restart
				Pia6820.sharedPia6820().reset();
				M6502.sharedM6502().reset();
				Memory.sharedMemory().setMemorySize(Integer.parseInt(memory.itemTitleAtIndex(
														memory.indexOfSelectedItem())));			
				break;
			case NSAlertPanel.OtherReturn: // cancel button
				// do nothing, just close the sheet
				break;
			case NSAlertPanel.AlternateReturn: // disregard
				// close the prefs window too
				close();
				break;
		}
	}
	
	private void updateDisplay() {
	
		// update the IBOutlets with their current values
		Screen screen = Screen.sharedScreen();

		bgColor.setColor(screen.getBgColor());
		textColor.setColor(screen.getTextColor());

		termSpeed.setIntValue(screen.getTerminalSpeed());
		oldMemorySize = Memory.sharedMemory().getMemorySize();
		memory.selectItemWithTitle(Integer.toString(oldMemorySize));
	}
	
	private void processChanges() {
	
		// update values
		Screen screen = Screen.sharedScreen();
		
		screen.setBgColor(bgColor.color());
		screen.setTextColor(textColor.color());

		screen.setTerminalSpeed(termSpeed.intValue());
		
		// close the window
		close();
		screen.setNeedsDisplay(true);
	}
}
