/*
 * Keyboard.java - Cocoa v 0.1 is a modified version of Keyboard Handler v 1.00 by:
 * Part of "Cocoa Pom 1"
 * Copyright (C) 2000 VERHILLE Arnaud
 * gist@wanadoo.fr
 * http://www.chez.com/apple1/
 * 
 * -- Modified/updated for Cocoa Pom by Joe Crobak (c) 2004--
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */

import java.awt.*;
import java.awt.event.*;

/**
 *  The Keyboard Class handles the translation between your keyboard keycodes and
 *      the Apple1 keyboard keycodes in an architecture independent way.
 *      
 *  An instance of the KeyboardTranslator is not necessary.  You must only call 
 *      KeyboardTranslator.translateCharacter(char) and the proper int will be returned.
 *
 * @author     VERHILLE Arnaud
 * @created    21 octobre 2000 
 * @last mod   Joe Crobak 4 January 2003
 */
public class KeyboardTranslator {
    
    // Default Constructor.
    public KeyboardTranslator() { }
    
    /**
     * The Key Translator. All lowercase ASCII is translated to upper case and then to the Apple 1 ASCII
     *   (The Apple 1 only accepts upper case letters for input)
     *
     * @param  tmp the character to be translated.
     * @return    -1 if the Keycode is unknown for the Apple1 else the Apple1 Keycode
     *
     * Called by:
     */
    public static int translateCharacter(char tmp) {
        tmp = Character.toUpperCase(tmp);        //translate to uppercase

	if ((tmp > 64) & (tmp < 91))            return (tmp + 0x80);	    // A to Z KeyCodes
	if ((tmp > 47) & (tmp < 58))            return (tmp + 0x80);        // O to 9 KeyCodes
	if (tmp == KeyEvent.VK_ENTER)           return 0x8D;                // enter
	if (tmp == KeyEvent.VK_ESCAPE)          return 0x9B;                // escape
	if (tmp == 127)                         return 0xDF;                // backspace 
	if (tmp == KeyEvent.VK_SPACE)           return 0x1F + 0x80;         // space
	if (tmp == KeyEvent.VK_COMMA)           return 0x2C + 0x80;         // comma
	if (tmp == KeyEvent.VK_CLOSE_BRACKET)   return 0x5D+0x80;           // close bracket
	if (tmp == KeyEvent.VK_OPEN_BRACKET)    return 0x5B+0x80;           // open bracket
	if (tmp == 46)                          return 0xAE;                // .
	if (tmp == 47)                          return 0xAF;                // :
	if (tmp == 43)                          return 0xAB;                // + (ADD)
	if (tmp == 42)                          return 0xAA;                // * (ASTERISK)
	if (tmp == 64)                          return 0xC0;                // @ (AT)
	if (tmp == 33)                          return 0xA1;                // ! (EXCLAMATION_MARK)
	if (tmp == 58)                          return 0x3A+0x80;           // / (BACK_SLASH)
	if (tmp == 94)                          return 0xDE;                // ^ (CIRCUMFLEX)
	if (tmp == 40)                          return 0xA8;                // ( (BRACELEFT)
	if (tmp == 41)                          return 0xA9;                // ) (BRACERIGHT)
	if (tmp == 37)                          return 0x25+0x80;           // % (AMPERSAND)
	if (tmp == 59)                          return 0x3B+0x80;           // ;
	if (tmp == 60)                          return 0xBC;                // <
	if (tmp == 61)                          return 0xBD;                // =
	if (tmp == 62)                          return 0xBE;                // >
	if (tmp == 63)                          return 0x3F+0x80;           // ?
	if (tmp == 92)                          return 0xDC;                // \
	if (tmp == 36)                          return 0x24+0x80;           // $  
	if (tmp == 34)                          return 0x22+0x80;			// "
	if (tmp == 35)                          return 0x23+0x80;			// #
	if (tmp == 38)                          return 0x26+0x80;			// &
	if (tmp == 39)                          return 0x27+0x80;			// '
	if (tmp == 45)                          return 0x2D+0x80;           // -

	// I'm not so sure these work because of the way that I handle input... I only pass the first
	//    character of the keypress event in Screen.keyDown()
	// Ctrl + ( A to Z) KeyCodes
	// Some are wiped away (ex: 8D for ENTER) ??
	if ((tmp > 0) & (tmp < 27))             return (tmp + 0x80);

	// Heavy Test	
	if (tmp == KeyEvent.VK_CONTROL) {
	    System.out.println("VK_CONTROL");
	    return 0x0D;
	}
        return -1;                  // No Match
    } // translateCharacter
}




