/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSButtonCell;
import com.apple.cocoa.application.NSColor;
import com.apple.cocoa.application.NSOpenPanel;
import com.apple.cocoa.application.NSTextField;
import com.apple.cocoa.application.NSWindowController;
import com.apple.cocoa.foundation.NSArray;
import com.apple.cocoa.foundation.NSMutableArray;
import com.apple.cocoa.foundation.NSSelector;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class loadWindowController
extends NSWindowController {
    public NSTextField hexAddress;
    public NSTextField hexAddressLabel;
    public NSButtonCell loadRaw;
    public NSButtonCell loadSaved;
    private boolean rawDataState;
    private static loadWindowController _sharedLoadWindowController;
    private static Memory mem;
    private NSOpenPanel op;
    private NSApplication myApp;

    loadWindowController() {
        super("Load");
        mem = Memory.sharedMemory();
        this.rawDataState = false;
        this.myApp = NSApplication.sharedApplication();
    }

    public void awakeFromNib() {
        this.hexAddressLabel.setTextColor(NSColor.lightGrayColor());
    }

    public static void setMemory(Memory newMem) {
        mem = newMem;
    }

    public static loadWindowController sharedLWC() {
        if (_sharedLoadWindowController == null) {
            _sharedLoadWindowController = new loadWindowController();
        }
        return _sharedLoadWindowController;
    }

    public void loadSavedButton(Object sender) {
        this.rawDataState = false;
        this.hexAddressLabel.setTextColor(NSColor.lightGrayColor());
        this.hexAddress.setEnabled(false);
    }

    public void loadRawButton(Object sender) {
        this.rawDataState = true;
        this.hexAddressLabel.setTextColor(NSColor.blackColor());
        this.hexAddress.setEnabled(true);
    }

    public void cancelButton(Object sender) {
        this.myApp.endSheet(this.window());
        this.close();
    }

    public void loadButton(Object sender) {
        this.myApp.endSheet(this.window());
        this.window().orderOut((Object)this);
        this.close();
        this.op = NSOpenPanel.openPanel();
        NSMutableArray fileExts = new NSMutableArray();
        int start = this.hexStringToInt(this.hexAddress.stringValue());
        if (start == -1) {
            return;
        }
        if (mem == null) {
            System.out.println("Memory was not initialized");
            return;
        }
        fileExts.addObject((Object)"txt");
        this.op.setAllowsMultipleSelection(false);
        this.op.beginSheetForDirectory(null, null, (NSArray)fileExts, MenuController.sharedMenuController().getEmuWindow(), (Object)this, new NSSelector("performMemoryLoad::", new Class[]{((Object)((Object)this)).getClass()}), null);
    }

    public void performMemoryLoad(NSOpenPanel sheet, int returnCode, Object contextInfo) {
        FileInputStream fis = null;
        int start = this.hexStringToInt(this.hexAddress.stringValue());
        if (returnCode == 1) {
            String fileName = (String)this.op.filenames().objectAtIndex(0);
            if (this.rawDataState) {
                try {
                    fis = new FileInputStream(fileName);
                    int size = fis.available();
                    int i = start;
                    while (i < start + size) {
                        mem.write(i, fis.read());
                        ++i;
                    }
                    fis.close();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else if (!this.rawDataState) {
                try {
                    String _strLine;
                    fis = new FileInputStream(fileName);
                    BufferedReader _br = new BufferedReader(new InputStreamReader(fis));
                    block5: while ((_strLine = _br.readLine()) != null) {
                        String _address;
                        int address;
                        System.out.println(_strLine);
                        if (_strLine.length() == 0 || _strLine.charAt(0) == '/' || (address = this.hexStringToInt(_address = _strLine.substring(0, 4))) == -1) continue;
                        int i = 6;
                        while (i < _strLine.length()) {
                            String _value = _strLine.substring(i, i + 2);
                            int value = this.hexStringToInt(_value);
                            if (value == -1) continue block5;
                            mem.write(address + (i - 6) / 3, value);
                            i += 3;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            this.close();
        } else if (returnCode == 0) {
            System.out.println("NSOpenPanel.CancelButton");
        }
    }

    public void textChange(Object sender) {
    }

    private int hexStringToInt(String s) {
        int max = 4;
        int total = 0;
        int p = 0;
        char[] schar = new char[4];
        if (s.length() < 4) {
            max = s.length();
        }
        s.getChars(0, max, schar, 0);
        int i = 0;
        while (i < max) {
            int j = max - 1 - i;
            if (i == 0) {
                p = 1;
            }
            if (i == 1) {
                p = 16;
            }
            if (i == 2) {
                p = 256;
            }
            if (i == 3) {
                p = 4096;
            }
            if (schar[j] == 'F' | schar[j] == 'f') {
                total += 15 * p;
            } else if (schar[j] == 'E' | schar[j] == 'e') {
                total += 14 * p;
            } else if (schar[j] == 'D' | schar[j] == 'd') {
                total += 13 * p;
            } else if (schar[j] == 'C' | schar[j] == 'c') {
                total += 12 * p;
            } else if (schar[j] == 'B' | schar[j] == 'b') {
                total += 11 * p;
            } else if (schar[j] == 'A' | schar[j] == 'a') {
                total += 10 * p;
            } else if (schar[j] == '9') {
                total += 9 * p;
            } else if (schar[j] == '8') {
                total += 8 * p;
            } else if (schar[j] == '7') {
                total += 7 * p;
            } else if (schar[j] == '6') {
                total += 6 * p;
            } else if (schar[j] == '5') {
                total += 5 * p;
            } else if (schar[j] == '4') {
                total += 4 * p;
            } else if (schar[j] == '3') {
                total += 3 * p;
            } else if (schar[j] == '2') {
                total += 2 * p;
            } else if (schar[j] == '1') {
                total += 1 * p;
            } else if (schar[j] != '0') {
                return -1;
            }
            ++i;
        }
        return total;
    }
}

