/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSBezierPath;
import com.apple.cocoa.application.NSColor;
import com.apple.cocoa.application.NSEvent;
import com.apple.cocoa.application.NSView;
import com.apple.cocoa.foundation.NSBundle;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSSize;
import java.io.FileInputStream;

public class Screen
extends NSView {
    private int[][] charTable;
    private int[][] screenTbl;
    private int indexX;
    private int indexY;
    private NSColor bgColor;
    private NSColor textColor;
    private int pixelSize;
    private boolean scanline;
    private int terminalSpeed;
    private long lastTime = System.currentTimeMillis();
    private Pia6820 pia;
    private static Screen _screen;

    public Screen(NSRect frame) {
        super(frame);
        _screen = this;
        this.charTable = new int[128][8];
        this.screenTbl = new int[40][24];
        this.loadCharTable();
        this.reset();
        this.pia = Pia6820.sharedPia6820();
    }

    public static Screen sharedScreen() {
        return _screen;
    }

    public void loadDefaults() {
        this.bgColor = NSColor.blackColor();
        this.textColor = NSColor.greenColor();
        this.pixelSize = 1;
        this.scanline = false;
        this.terminalSpeed = 60;
    }

    public void reset() {
        this.indexY = 0;
        this.indexX = 0;
        this.initScreenTbl();
        this.setNeedsDisplay(true);
    }

    public void setBgColor(NSColor bg) {
        this.bgColor = bg;
    }

    public void setTextColor(NSColor text) {
        this.textColor = text;
    }

    public void setPixelSize(int n) {
        this.pixelSize = n;
        MenuController.sharedMenuController().getEmuWindow().setContentSize(new NSSize((float)this.pixelSize * 280.0f, (float)this.pixelSize * 192.0f));
    }

    public void setTerminalSpeed(int n) {
        this.terminalSpeed = n;
    }

    public void setScanline(boolean scanline) {
        this.scanline = scanline;
    }

    public NSColor getBgColor() {
        return this.bgColor;
    }

    public NSColor getTextColor() {
        return this.textColor;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public int getTerminalSpeed() {
        return this.terminalSpeed;
    }

    public boolean getScanline() {
        return this.scanline;
    }

    public void outputDsp(int dsp) {
        switch (dsp) {
            case 0: 
            case 127: {
                break;
            }
            case 95: {
                if (this.indexX == 0) {
                    --this.indexY;
                    this.indexX = 39;
                } else {
                    --this.indexX;
                }
                this.screenTbl[this.indexX][this.indexY] = 0;
                break;
            }
            case 10: 
            case 13: {
                this.indexX = 0;
                ++this.indexY;
                break;
            }
            default: {
                this.screenTbl[this.indexX++][this.indexY] = dsp;
            }
        }
        if (this.indexX == 40) {
            this.indexX = 0;
            ++this.indexY;
        }
        if (this.indexY == 24) {
            this.newLine();
            --this.indexY;
        }
        this.delayOutputToMatchTerminalSpeed();
        this.display();
    }

    private void delayOutputToMatchTerminalSpeed() {
        int sleepMillis = (int)((long)(1000 / this.terminalSpeed) - (System.currentTimeMillis() - this.lastTime));
        if (sleepMillis > 0) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        this.lastTime = System.currentTimeMillis();
    }

    public void drawRect(NSRect frame) {
        NSRect myBounds = this.bounds();
        this.bgColor.set();
        NSBezierPath.fillRect((NSRect)myBounds);
        this.textColor.set();
        int i = 0;
        while (i < 40) {
            int j = 0;
            while (j < 24) {
                int xPosition = i * (this.pixelSize * 7);
                int yPosition = j * (this.pixelSize * 8);
                this.drawChar(frame, xPosition, yPosition, this.screenTbl[i][j]);
                ++j;
            }
            ++i;
        }
        this.drawChar(frame, this.indexX * (this.pixelSize * 7), this.indexY * (this.pixelSize * 8), 1);
    }

    private void drawChar(NSRect frame, int xPosition, int yPosition, int characNumber) {
        int k = 0;
        while (k < 8) {
            int l = 1;
            while (l < 8) {
                if ((this.charTable[characNumber][k] & 1 << l) == 1 << l) {
                    NSRect charArea = new NSRect((float)(xPosition + this.pixelSize * (l - 1)), (float)(yPosition + this.pixelSize * k), (float)this.pixelSize, (float)(this.pixelSize - (this.scanline ? 1 : 0)));
                    NSBezierPath.fillRect((NSRect)charArea);
                }
                ++l;
            }
            ++k;
        }
    }

    public boolean acceptsFirstResponder() {
        return true;
    }

    public boolean isFlipped() {
        return true;
    }

    public void keyDown(NSEvent theEvent) {
        if (this.pia.getKbdInterrupts()) {
            int result = KeyboardTranslator.translateCharacter(theEvent.characters().charAt(0));
            if (result != -1) {
                this.pia.writeKbd(result);
                this.pia.writeKbdCr(167);
            } else {
                System.out.println("The key \"" + theEvent.characters().charAt(0) + "\" is an invalid key.");
            }
        } else {
            System.out.println("Keyboard interrupts disabled.");
        }
    }

    private void loadCharTable() {
        NSBundle bund = NSBundle.mainBundle();
        String filename = bund.resourcePath() + "/apple1.vid";
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            boolean k = false;
            int i = 0;
            while (i < 128) {
                int j = 0;
                while (j < 8) {
                    this.charTable[i][j] = fis.read();
                    ++j;
                }
                ++i;
            }
            fis.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void initScreenTbl() {
        int i = 0;
        while (i < 40) {
            int j = 0;
            while (j < 24) {
                this.screenTbl[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    private void newLine() {
        int i = 0;
        while (i < 40) {
            int j = 0;
            while (j < 23) {
                this.screenTbl[i][j] = this.screenTbl[i][j + 1];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 40) {
            this.screenTbl[i][23] = 0;
            ++i;
        }
        this.setNeedsDisplay(true);
    }
}

