/*
 * Decompiled with CFR 0.152.
 */
public class Pia6820 {
    private int dspCr;
    private int dsp;
    private int kbdCr;
    private int kbd;
    private boolean kbdInterrupts;
    private boolean dspOutput;
    private static Pia6820 _pia;

    public Pia6820() {
        this.reset();
    }

    public void reset() {
        this.kbdInterrupts = false;
        this.kbdCr = 0;
        this.dspOutput = false;
        this.dspCr = 0;
    }

    public static Pia6820 sharedPia6820() {
        if (_pia == null) {
            _pia = new Pia6820();
        }
        return _pia;
    }

    public void setKbdInterrupts(boolean b) {
        this.kbdInterrupts = b;
    }

    public void writeDspCr(int dspCr) {
        if (!this.dspOutput) {
            if (dspCr >= 128) {
                this.dspOutput = true;
            }
            dspCr = 0;
        } else {
            this.dspCr = dspCr;
        }
    }

    public void writeDsp(int dsp) {
        if (dsp >= 128) {
            dsp -= 128;
        }
        Screen.sharedScreen().outputDsp(dsp);
        this.dsp = dsp;
    }

    public void writeKbdCr(int kbdCr) {
        if (!this.getKbdInterrupts()) {
            if (kbdCr >= 128) {
                this.setKbdInterrupts(true);
                kbdCr = 0;
            }
        } else {
            this.kbdCr = kbdCr;
        }
    }

    public void writeKbd(int kbd) {
        this.kbd = kbd;
    }

    public boolean getKbdInterrupts() {
        return this.kbdInterrupts;
    }

    public boolean getDspOutput() {
        return this.dspOutput;
    }

    public int readDspCr() {
        return this.dspCr;
    }

    public int readDsp() {
        return this.dsp;
    }

    public int readKbdCr() {
        if (this.getKbdInterrupts() && this.kbdCr >= 128) {
            this.kbdCr = 0;
            return 167;
        }
        return this.kbdCr;
    }

    public int readKbd() {
        return this.kbd;
    }
}

