/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSButtonCell;
import com.apple.cocoa.application.NSSavePanel;
import com.apple.cocoa.application.NSTextField;
import com.apple.cocoa.application.NSWindowController;
import com.apple.cocoa.foundation.NSSelector;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class MySaveSheetController
extends NSWindowController {
    public NSTextField endAddress;
    public NSButtonCell saveAll;
    public NSButtonCell savePortion;
    public NSTextField startAddress;
    private static MySaveSheetController _sharedMySaveSheetController;
    private NSSavePanel sp;
    private boolean fullSave;

    public MySaveSheetController() {
        super("saveSheet");
    }

    public void awakeFromNib() {
        this.fullSave = false;
    }

    public static MySaveSheetController sharedMySaveSheetController() {
        if (_sharedMySaveSheetController == null) {
            _sharedMySaveSheetController = new MySaveSheetController();
        }
        return _sharedMySaveSheetController;
    }

    public void cancelButton(Object sender) {
        NSApplication.sharedApplication().endSheet(this.window());
        this.close();
    }

    public void okButton(Object sender) {
        NSApplication.sharedApplication().endSheet(this.window());
        this.window().orderOut((Object)this);
        this.close();
        this.sp = NSSavePanel.savePanel();
        this.sp.setCanSelectHiddenExtension(true);
        this.sp.setExtensionHidden(false);
        this.sp.setCanCreateDirectories(true);
        this.sp.beginSheetForDirectory(null, "memory.txt", MenuController.sharedMenuController().getEmuWindow(), (Object)this, new NSSelector("performMemorySave::", new Class[]{((Object)((Object)this)).getClass()}), null);
    }

    public void performMemorySave(NSSavePanel sheet, int returnCode, Object contextInfo) {
        String filename = this.sp.filename();
        try {
            int end;
            int start;
            FileOutputStream fos = new FileOutputStream(filename);
            PrintStream ps = new PrintStream(fos);
            Memory mem = Memory.sharedMemory();
            if (this.fullSave) {
                start = 0;
                end = mem.getMemorySize() * 1024 - 1;
            } else {
                start = Integer.parseInt(this.startAddress.stringValue().trim(), 16);
                end = Integer.parseInt(this.endAddress.stringValue().trim(), 16);
            }
            try {
                int i = start;
                while (i <= end) {
                    if (i % 8 == 0 || i == start) {
                        ps.print(this.intToHexString(i, 4) + ": ");
                    }
                    ps.print(this.intToHexString(mem.read(i), 2));
                    if (i % 8 == 7 || i == end) {
                        ps.println();
                    } else {
                        ps.print(" ");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ps.print("//could not save to data file.  likely because of an invalid start/finish address");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void saveAllButton(Object sender) {
        this.fullSave = true;
    }

    public void savePortionButton(Object sender) {
        this.fullSave = false;
    }

    public void textActivate(Object sender) {
        this.savePortion.setState(1);
        this.saveAll.setState(0);
        this.fullSave = false;
    }

    private String intToHexString(int x, int stringSize) {
        String hexVal = Integer.toHexString(x).toUpperCase();
        while (hexVal.length() < stringSize) {
            hexVal = '0' + hexVal;
        }
        return hexVal;
    }
}

