/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSButtonCell;
import com.apple.cocoa.application.NSSavePanel;
import com.apple.cocoa.application.NSTextField;
import com.apple.cocoa.application.NSWindowController;
import com.apple.cocoa.foundation.NSSelector;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class MySaveController
extends NSWindowController {
    public NSTextField comment;
    public NSTextField endAddress;
    public NSTextField endAddressLabel;
    public NSButtonCell saveAll;
    public NSButtonCell savePortion;
    public NSTextField startAddress;
    public NSTextField startAddressLabel;
    private static MySaveController _sharedMySaveController;
    private NSSavePanel sp;
    private boolean fullSave;

    public MySaveController() {
        super("Save");
    }

    public void awakeFromNib() {
        this.fullSave = false;
    }

    public static MySaveController sharedMySaveController() {
        if (_sharedMySaveController == null) {
            _sharedMySaveController = new MySaveController();
            System.out.println("Creating MySaveController shared instance");
        }
        return _sharedMySaveController;
    }

    public void cancelButton(Object sender) {
        NSApplication.sharedApplication().endSheet(this.window());
        this.close();
    }

    public void okButton(Object sender) {
        NSApplication.sharedApplication().endSheet(this.window());
        this.window().orderOut((Object)this);
        this.close();
        this.sp = NSSavePanel.savePanel();
        this.sp.setCanSelectHiddenExtension(true);
        this.sp.setExtensionHidden(false);
        this.sp.setCanCreateDirectories(true);
        this.sp.beginSheetForDirectory(null, "memory.txt", MenuController.sharedMenuController().getEmuWindow(), (Object)this, new NSSelector("performMemorySave::", new Class[]{((Object)((Object)this)).getClass()}));
    }

    public void performMemorySave(NSSavePanel sheet, int returnCode, Object contextInfo) {
        block6: {
            String filename = this.sp.filename();
            try {
                FileOutputStream fos = new FileOutputStream(filename);
                PrintStream ps = new PrintStream(fos);
                Memory mem = Memory.sharedMemory();
                if (!this.fullSave) break block6;
                int i = 0;
                while (i < mem.getMemorySize() * 1024) {
                    if (i % 8 == 0) {
                        ps.print(Integer.toHexString(i) + ": ");
                    }
                    ps.print(mem.read(i));
                    if (i % 8 == 7) {
                        ps.println();
                    } else {
                        ps.print(" ");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void saveAllButton(Object sender) {
        this.fullSave = true;
    }

    public void savePortionButton(Object sender) {
        this.fullSave = false;
    }

    public void textActivate(Object sender) {
        this.savePortion.setEnabled(true);
        this.saveAll.setEnabled(false);
    }
}

