/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSAlertPanel;
import com.apple.cocoa.application.NSButton;
import com.apple.cocoa.application.NSColor;
import com.apple.cocoa.application.NSColorWell;
import com.apple.cocoa.application.NSPopUpButton;
import com.apple.cocoa.application.NSTextField;
import com.apple.cocoa.application.NSWindow;
import com.apple.cocoa.application.NSWindowController;
import com.apple.cocoa.foundation.NSBundle;
import com.apple.cocoa.foundation.NSSelector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class MyPrefsController
extends NSWindowController {
    public NSColorWell bgColor;
    public NSPopUpButton memory;
    public NSButton scanline;
    public NSTextField termSpeed;
    public NSColorWell textColor;
    public NSWindow window;
    public NSPopUpButton windowSize;
    private static MyPrefsController _myPrefsController;
    private int oldMemorySize;

    public MyPrefsController() {
        _myPrefsController = this;
    }

    public void showWindow(Object sender) {
        if (this.window == null || !this.window.isVisible()) {
            this.updateDisplay();
            super.showWindow(sender);
        } else {
            this.window.orderFront(sender);
        }
    }

    public static MyPrefsController sharedMyPrefsController() {
        if (_myPrefsController == null) {
            _myPrefsController = new MyPrefsController();
        }
        return _myPrefsController;
    }

    public boolean loadPreferencesFile() {
        System.out.println("inside load prefs");
        NSBundle bund = NSBundle.mainBundle();
        String filename = bund.resourcePath() + "/pom1.preferences";
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = br.readLine();
            int pixelSize = Integer.parseInt(line);
            Screen.sharedScreen().setPixelSize(pixelSize);
            line = br.readLine();
            System.out.println("Scanline reads: " + line);
            boolean scanln = line.charAt(0) != '0';
            System.out.println("Scanln bool: " + scanln);
            Screen.sharedScreen().setScanline(scanln);
            line = br.readLine();
            float red = Float.parseFloat(line);
            line = br.readLine();
            float green = Float.parseFloat(line);
            line = br.readLine();
            float blue = Float.parseFloat(line);
            line = br.readLine();
            float alpha = Float.parseFloat(line);
            NSColor bgColor = NSColor.colorWithCalibratedRGB((float)red, (float)green, (float)blue, (float)alpha);
            Screen.sharedScreen().setBgColor(bgColor);
            line = br.readLine();
            red = Float.parseFloat(line);
            line = br.readLine();
            green = Float.parseFloat(line);
            line = br.readLine();
            blue = Float.parseFloat(line);
            line = br.readLine();
            alpha = Float.parseFloat(line);
            NSColor textColor = NSColor.colorWithCalibratedRGB((float)red, (float)green, (float)blue, (float)alpha);
            Screen.sharedScreen().setTextColor(textColor);
            line = br.readLine();
            int outputSpeed = Integer.parseInt(line);
            Screen.sharedScreen().setTerminalSpeed(outputSpeed);
            System.out.println("output speed: " + outputSpeed);
            line = br.readLine();
            int memorySize = Integer.parseInt(line);
            System.out.println("Setting memory size to: " + memorySize);
            Memory.sharedMemory().setMemorySize(memorySize);
            Memory.sharedMemory().reset();
            fis.close();
        }
        catch (Exception e) {
            System.out.println(e + "in loadPrefsFile");
        }
        return true;
    }

    public void savePreferencesFile() {
        NSBundle bund = NSBundle.mainBundle();
        String filename = bund.resourcePath() + "/pom1.preferences";
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            PrintStream ps = new PrintStream(fos);
            ps.println(Screen.sharedScreen().getPixelSize());
            ps.println(Screen.sharedScreen().getScanline() ? 1 : 0);
            NSColor bgColor = Screen.sharedScreen().getBgColor().colorUsingColorSpaceName("NSCalibratedRGBColorSpace");
            ps.println(bgColor.redComponent());
            ps.println(bgColor.greenComponent());
            ps.println(bgColor.blueComponent());
            ps.println(bgColor.alphaComponent());
            NSColor textColor = Screen.sharedScreen().getTextColor().colorUsingColorSpaceName("NSCalibratedRGBColorSpace");
            ps.println(textColor.redComponent());
            ps.println(textColor.greenComponent());
            ps.println(textColor.blueComponent());
            ps.println(textColor.alphaComponent());
            ps.println(Screen.sharedScreen().getTerminalSpeed());
            ps.println(Memory.sharedMemory().getMemorySize());
            ps.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void cancelButton(Object sender) {
        this.close();
    }

    public void defaultsButton(Object sender) {
        this.bgColor.setColor(NSColor.blackColor());
        this.textColor.setColor(NSColor.greenColor());
        this.termSpeed.setIntValue(60);
        this.memory.selectItemWithTitle("64");
    }

    public void okButton(Object sender) {
        if (Integer.parseInt(this.memory.itemTitleAtIndex(this.memory.indexOfSelectedItem())) != this.oldMemorySize) {
            NSAlertPanel.beginAlertSheet((String)"You have changed the memory size which requires a \"hard\" restart.  Do you wish to continue?", (String)"Hard Restart", (String)"Disregard Changes", (String)"Cancel", (NSWindow)this.window, (Object)((Object)this), (NSSelector)new NSSelector("sheetDidEnd::", new Class[]{((Object)((Object)this)).getClass()}), null, null, (String)"This action cannot be undone.");
            return;
        }
        this.processChanges();
    }

    public void sheetDidEnd(NSWindow sheet, int returnCode, Object contextInfo) {
        switch (returnCode) {
            case 1: {
                this.processChanges();
                Pia6820.sharedPia6820().reset();
                M6502.sharedM6502().reset();
                Memory.sharedMemory().setMemorySize(Integer.parseInt(this.memory.itemTitleAtIndex(this.memory.indexOfSelectedItem())));
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.close();
            }
        }
    }

    private void updateDisplay() {
        Screen screen = Screen.sharedScreen();
        this.bgColor.setColor(screen.getBgColor());
        this.textColor.setColor(screen.getTextColor());
        this.termSpeed.setIntValue(screen.getTerminalSpeed());
        this.oldMemorySize = Memory.sharedMemory().getMemorySize();
        this.memory.selectItemWithTitle(Integer.toString(this.oldMemorySize));
    }

    private void processChanges() {
        Screen screen = Screen.sharedScreen();
        screen.setBgColor(this.bgColor.color());
        screen.setTextColor(this.textColor.color());
        screen.setTerminalSpeed(this.termSpeed.intValue());
        this.close();
        screen.setNeedsDisplay(true);
    }
}

