/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSMenu;
import com.apple.cocoa.application.NSMenuItem;
import com.apple.cocoa.application.NSOpenPanel;
import com.apple.cocoa.application.NSWindow;
import com.apple.cocoa.foundation.NSArray;
import com.apple.cocoa.foundation.NSMutableArray;
import com.apple.cocoa.foundation.NSNotification;
import com.apple.cocoa.foundation.NSNotificationCenter;
import com.apple.cocoa.foundation.NSObject;
import com.apple.cocoa.foundation.NSSelector;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class MenuController
extends NSObject {
    private NSWindow mainWindow;
    private NSMenu menubar;
    private NSMenuItem scanline;
    private static MenuController _menuController;
    private NSOpenPanel op;
    private Screen screen = Screen.sharedScreen();
    static /* synthetic */ Class class$com$apple$cocoa$foundation$NSNotification;

    public static MenuController sharedMenuController() {
        if (_menuController == null) {
            _menuController = new MenuController();
        }
        return _menuController;
    }

    public void awakeFromNib() {
        System.out.println("loading preference file");
        if (!MyPrefsController.sharedMyPrefsController().loadPreferencesFile()) {
            Memory.sharedMemory().loadDefaults();
            Memory.sharedMemory().reset();
            Screen.sharedScreen().loadDefaults();
        }
        M6502.sharedM6502().start();
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("applicationWillTerminate", new Class[]{class$com$apple$cocoa$foundation$NSNotification == null ? (class$com$apple$cocoa$foundation$NSNotification = MenuController.class$("com.apple.cocoa.foundation.NSNotification")) : class$com$apple$cocoa$foundation$NSNotification}), "NSApplicationWillTerminateNotification", null);
        Screen.sharedScreen().setNeedsDisplay(true);
        this.getEmuWindow().setFrameUsingName("cocoa pom 1");
        if (Screen.sharedScreen().getScanline()) {
            this.scanline.setState(1);
        } else {
            this.scanline.setState(0);
        }
    }

    public NSWindow getEmuWindow() {
        NSArray windows = NSApplication.sharedApplication().windows();
        int i = 0;
        while (i < windows.count()) {
            if (((NSWindow)windows.objectAtIndex(i)).title().equals("Cocoa Pom 1")) {
                return (NSWindow)windows.objectAtIndex(i);
            }
            ++i;
        }
        return null;
    }

    public void fileSave(Object sender) {
        NSApplication.sharedApplication().beginSheet(MySaveSheetController.sharedMySaveSheetController().window(), this.getEmuWindow(), (Object)this, null, null);
    }

    public void fileLoad(Object sender) {
        NSMutableArray fileExts = new NSMutableArray();
        fileExts.addObject((Object)"txt");
        this.op = NSOpenPanel.openPanel();
        this.op.setAllowsMultipleSelection(false);
        this.op.beginSheetForDirectory(null, null, null, MenuController.sharedMenuController().getEmuWindow(), (Object)this, new NSSelector("performMemoryLoad::", new Class[]{((Object)((Object)this)).getClass()}), null);
    }

    public void performMemoryLoad(NSOpenPanel sheet, int returnCode, Object contextInfo) {
        FileInputStream fis = null;
        if (returnCode == 1) {
            String fileName = (String)this.op.filenames().objectAtIndex(0);
            try {
                String _strLine;
                fis = new FileInputStream(fileName);
                BufferedReader _br = new BufferedReader(new InputStreamReader(fis));
                block6: while ((_strLine = _br.readLine()) != null) {
                    int address;
                    if (_strLine.length() == 0 || _strLine.charAt(0) == '/') continue;
                    int k = 0;
                    while (k < _strLine.length()) {
                        if (_strLine.charAt(k) == ':') break;
                        ++k;
                    }
                    String _address = _strLine.substring(0, k);
                    try {
                        address = Integer.parseInt(_address.trim(), 16);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    int i = k + 2;
                    while (i < _strLine.length()) {
                        String _value = _strLine.substring(i, i + 2);
                        try {
                            int value = Integer.parseInt(_value.trim(), 16);
                            Memory.sharedMemory().write(address + (i - (k + 2)) / 3, value);
                        }
                        catch (Exception e) {
                            continue block6;
                        }
                        i += 3;
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else if (returnCode == 0) {
            // empty if block
        }
    }

    public void emuReset(Object sender) {
        Pia6820.sharedPia6820().reset();
        M6502.sharedM6502().reset();
    }

    public void emuHard(Object sender) {
        M6502 micro = M6502.sharedM6502();
        micro.stop();
        micro.reset();
        Pia6820.sharedPia6820().reset();
        Screen.sharedScreen().reset();
        Memory.sharedMemory().reset();
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        micro.start();
    }

    public void emuConfig(Object sender) {
        MyPrefsController.sharedMyPrefsController().showWindow(sender);
    }

    public void normalSize(Object sender) {
        Screen.sharedScreen().setPixelSize(1);
        Screen.sharedScreen().setScanline(false);
        this.scanline.setState(0);
        Screen.sharedScreen().setNeedsDisplay(true);
    }

    public void doubleSize(Object sender) {
        Screen.sharedScreen().setPixelSize(2);
        Screen.sharedScreen().setNeedsDisplay(true);
    }

    public void tripleSize(Object sender) {
        Screen.sharedScreen().setPixelSize(3);
        Screen.sharedScreen().setNeedsDisplay(true);
    }

    public void toggleScanline(Object sender) {
        if (this.scanline.state() == 0) {
            this.scanline.setState(1);
            Screen.sharedScreen().setScanline(true);
        } else {
            this.scanline.setState(0);
            Screen.sharedScreen().setScanline(false);
        }
        Screen.sharedScreen().setNeedsDisplay(true);
    }

    public boolean validateMenuItem(Object sender) {
        return !((NSMenuItem)sender).title().equals("Scanline") || Screen.sharedScreen().getPixelSize() != 1;
    }

    public void applicationWillTerminate(NSNotification aNotification) {
        MyPrefsController.sharedMyPrefsController().savePreferencesFile();
        this.getEmuWindow().saveFrameUsingName("cocoa pom 1");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

