/*
 * Decompiled with CFR 0.152.
 */
import com.apple.cocoa.foundation.NSBundle;
import java.io.File;
import java.io.FileInputStream;

public class Memory {
    private boolean ram8k;
    private boolean writeInRom;
    private boolean appletMode = false;
    private int[] mem;
    private Pia6820 pia = Pia6820.sharedPia6820();
    private static Memory _mem;
    private int memorySize;

    public static Memory sharedMemory() {
        if (_mem == null) {
            _mem = new Memory();
        }
        return _mem;
    }

    public void loadDefaults() {
        this.memorySize = 65536;
        this.mem = new int[this.memorySize];
        this.ram8k = false;
        this.writeInRom = true;
    }

    public int getMemorySize() {
        return this.memorySize / 1024;
    }

    public void setMemorySize(int size) {
        this.memorySize = size * 1024;
        this.mem = new int[this.memorySize];
        if (size <= 8) {
            this.setRam8k(true);
        } else {
            this.setRam8k(false);
        }
    }

    public void setRam8k(boolean b) {
        this.ram8k = b;
    }

    public void setWriteInRom(boolean b) {
        this.writeInRom = b;
    }

    public int read(int address) {
        if (address == 53267) {
            return this.pia.readDspCr();
        }
        if (address == 53266) {
            return this.pia.readDsp();
        }
        if (address == 53265) {
            return this.pia.readKbdCr();
        }
        if (address == 53264) {
            return this.pia.readKbd();
        }
        return this.mem[address];
    }

    public void write(int address, int value) {
        if (address == 53267) {
            this.mem[address] = value;
            this.pia.writeDspCr(value);
            return;
        }
        if (address == 53266) {
            this.mem[address] = value;
            this.pia.writeDsp(value);
            return;
        }
        if (address == 53265) {
            this.mem[address] = value;
            this.pia.writeKbdCr(value);
            return;
        }
        if (address == 53264) {
            this.mem[address] = value;
            this.pia.writeKbd(value);
            return;
        }
        if (address >= 65280 && !this.writeInRom) {
            return;
        }
        if (this.ram8k && address >= 8192 && address < 65280) {
            return;
        }
        this.mem[address] = value;
    }

    public void reset() {
        int i = 0;
        while (i < this.memorySize) {
            this.mem[i] = 0;
            ++i;
        }
        this.loadRom();
    }

    public int[] dumpMemory(int start, int end) {
        int[] fbrut = new int[end - start + 1];
        int i = 0;
        while (i < end - start + 1) {
            fbrut[i] = this.mem[start + i] & 0xFF;
            ++i;
        }
        return fbrut;
    }

    public void loadRom() {
        NSBundle bund = NSBundle.mainBundle();
        String filename = bund.resourcePath() + "/apple1.rom";
        FileInputStream fis = null;
        File file = new File(filename);
        int startingAddress = 65280;
        try {
            fis = new FileInputStream(filename);
            int i = startingAddress;
            while (i < 65536) {
                this.mem[i] = fis.read();
                ++i;
            }
            fis.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

