/*
 * Decompiled with CFR 0.152.
 */
public class M6502
implements Runnable {
    protected Memory mem;
    private int accumulator;
    private int xRegister;
    private int yRegister;
    private boolean N;
    private boolean V;
    private boolean M = true;
    private boolean B;
    private boolean D = false;
    private boolean I = true;
    private boolean Z;
    private boolean C;
    private int statusRegister;
    private int programCounter;
    private int stackPointer = 255;
    private boolean IRQ = false;
    private boolean NMI = false;
    private volatile Thread runner = null;
    private byte btmp;
    private int op;
    private int opL;
    private int opH;
    private int ptr;
    private int ptrH;
    private int ptrL;
    private int tmp;
    private long lastTime = System.currentTimeMillis();
    private int cycles;
    private int cyclesBeforeSynchro = 50000;
    private int synchroMillis = 50;
    private static M6502 _M6502;

    public M6502() {
        this.mem = Memory.sharedMemory();
        this.programCounter = this.memReadAbsolute(65532);
    }

    public static M6502 sharedM6502() {
        if (_M6502 == null) {
            _M6502 = new M6502();
        }
        return _M6502;
    }

    public void setSpeed(int freq, int synchroMillis) {
        this.cyclesBeforeSynchro = synchroMillis * freq;
        this.synchroMillis = synchroMillis;
    }

    public void reset() {
        this.I = true;
        this.stackPointer = 255;
        this.programCounter = this.memReadAbsolute(65532);
    }

    public void IRQ(boolean state) {
        this.IRQ = state;
    }

    public void NMI() {
        this.NMI = true;
    }

    public void start() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public void stop() {
        this.runner = null;
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            this.synchronize();
            this.cycles = 0;
            while (this.cycles < this.cyclesBeforeSynchro) {
                if (!this.I && this.IRQ) {
                    this.handleIRQ();
                }
                if (this.NMI) {
                    this.handleNMI();
                }
                this.executeOpcode();
            }
        }
    }

    public void executeOpcode() {
        int opcode = this.mem.read(this.programCounter++);
        switch (opcode) {
            case 0: {
                this.Imm();
                this.BRK();
                break;
            }
            case 1: {
                this.IndZeroX();
                this.ORA();
                break;
            }
            case 2: {
                this.Hang();
                break;
            }
            case 3: {
                this.Unoff();
                break;
            }
            case 4: {
                this.Unoff2();
                break;
            }
            case 5: {
                this.Zero();
                this.ORA();
                break;
            }
            case 6: {
                this.Zero();
                this.ASL();
                break;
            }
            case 7: {
                this.Unoff();
                break;
            }
            case 8: {
                this.Imp();
                this.PHP();
                break;
            }
            case 9: {
                this.Imm();
                this.ORA();
                break;
            }
            case 10: {
                this.Imp();
                this.ASL_A();
                break;
            }
            case 11: {
                this.Imm();
                this.AND();
                break;
            }
            case 12: {
                this.Unoff3();
                break;
            }
            case 13: {
                this.Abs();
                this.ORA();
                break;
            }
            case 14: {
                this.Abs();
                this.ASL();
                break;
            }
            case 15: {
                this.Unoff();
                break;
            }
            case 16: {
                this.Rel();
                this.BPL();
                break;
            }
            case 17: {
                this.IndZeroY();
                this.ORA();
                break;
            }
            case 18: {
                this.Hang();
                break;
            }
            case 19: {
                this.Unoff();
                break;
            }
            case 20: {
                this.Unoff2();
                break;
            }
            case 21: {
                this.ZeroX();
                this.ORA();
                break;
            }
            case 22: {
                this.ZeroX();
                this.ASL();
                break;
            }
            case 23: {
                this.Unoff();
                break;
            }
            case 24: {
                this.Imp();
                this.CLC();
                break;
            }
            case 25: {
                this.AbsY();
                this.ORA();
                break;
            }
            case 26: {
                this.Unoff1();
                break;
            }
            case 27: {
                this.Unoff();
                break;
            }
            case 28: {
                this.Unoff3();
                break;
            }
            case 29: {
                this.AbsX();
                this.ORA();
                break;
            }
            case 30: {
                this.WAbsX();
                this.ASL();
                break;
            }
            case 31: {
                this.Unoff();
                break;
            }
            case 32: {
                this.JSR();
                break;
            }
            case 33: {
                this.IndZeroX();
                this.AND();
                break;
            }
            case 34: {
                this.Hang();
                break;
            }
            case 35: {
                this.Unoff();
                break;
            }
            case 36: {
                this.Zero();
                this.BIT();
                break;
            }
            case 37: {
                this.Zero();
                this.AND();
                break;
            }
            case 38: {
                this.Zero();
                this.ROL();
                break;
            }
            case 39: {
                this.Unoff();
                break;
            }
            case 40: {
                this.Imp();
                this.PLP();
                break;
            }
            case 41: {
                this.Imm();
                this.AND();
                break;
            }
            case 42: {
                this.Imp();
                this.ROL_A();
                break;
            }
            case 43: {
                this.Imm();
                this.AND();
                break;
            }
            case 44: {
                this.Abs();
                this.BIT();
                break;
            }
            case 45: {
                this.Abs();
                this.AND();
                break;
            }
            case 46: {
                this.Abs();
                this.ROL();
                break;
            }
            case 47: {
                this.Unoff();
                break;
            }
            case 48: {
                this.Rel();
                this.BMI();
                break;
            }
            case 49: {
                this.IndZeroY();
                this.AND();
                break;
            }
            case 50: {
                this.Hang();
                break;
            }
            case 51: {
                this.Unoff();
                break;
            }
            case 52: {
                this.Unoff2();
                break;
            }
            case 53: {
                this.ZeroX();
                this.AND();
                break;
            }
            case 54: {
                this.ZeroX();
                this.ROL();
                break;
            }
            case 55: {
                this.Unoff();
                break;
            }
            case 56: {
                this.Imp();
                this.SEC();
                break;
            }
            case 57: {
                this.AbsY();
                this.AND();
                break;
            }
            case 58: {
                this.Unoff1();
                break;
            }
            case 59: {
                this.Unoff();
                break;
            }
            case 60: {
                this.Unoff3();
                break;
            }
            case 61: {
                this.AbsX();
                this.AND();
                break;
            }
            case 62: {
                this.WAbsX();
                this.ROL();
                break;
            }
            case 63: {
                this.Unoff();
                break;
            }
            case 64: {
                this.Imp();
                this.RTI();
                break;
            }
            case 65: {
                this.IndZeroX();
                this.EOR();
                break;
            }
            case 66: {
                this.Hang();
                break;
            }
            case 67: {
                this.Unoff();
                break;
            }
            case 68: {
                this.Unoff2();
                break;
            }
            case 69: {
                this.Zero();
                this.EOR();
                break;
            }
            case 70: {
                this.Zero();
                this.LSR();
                break;
            }
            case 71: {
                this.Unoff();
                break;
            }
            case 72: {
                this.Imp();
                this.PHA();
                break;
            }
            case 73: {
                this.Imm();
                this.EOR();
                break;
            }
            case 74: {
                this.Imp();
                this.LSR_A();
                break;
            }
            case 75: {
                this.Unoff();
                break;
            }
            case 76: {
                this.Abs();
                this.JMP();
                break;
            }
            case 77: {
                this.Abs();
                this.EOR();
                break;
            }
            case 78: {
                this.Abs();
                this.LSR();
                break;
            }
            case 79: {
                this.Unoff();
                break;
            }
            case 80: {
                this.Rel();
                this.BVC();
                break;
            }
            case 81: {
                this.IndZeroY();
                this.EOR();
                break;
            }
            case 82: {
                this.Hang();
                break;
            }
            case 83: {
                this.Unoff();
                break;
            }
            case 84: {
                this.Unoff2();
                break;
            }
            case 85: {
                this.ZeroX();
                this.EOR();
                break;
            }
            case 86: {
                this.ZeroX();
                this.LSR();
                break;
            }
            case 87: {
                this.Unoff();
                break;
            }
            case 88: {
                this.Imp();
                this.CLI();
                break;
            }
            case 89: {
                this.AbsY();
                this.EOR();
                break;
            }
            case 90: {
                this.Unoff1();
                break;
            }
            case 91: {
                this.Unoff();
                break;
            }
            case 92: {
                this.Unoff3();
                break;
            }
            case 93: {
                this.AbsX();
                this.EOR();
                break;
            }
            case 94: {
                this.WAbsX();
                this.LSR();
                break;
            }
            case 95: {
                this.Unoff();
                break;
            }
            case 96: {
                this.Imp();
                this.RTS();
                break;
            }
            case 97: {
                this.IndZeroX();
                this.ADC();
                break;
            }
            case 98: {
                this.Hang();
                break;
            }
            case 99: {
                this.Unoff();
                break;
            }
            case 100: {
                this.Unoff2();
                break;
            }
            case 101: {
                this.Zero();
                this.ADC();
                break;
            }
            case 102: {
                this.Zero();
                this.ROR();
                break;
            }
            case 103: {
                this.Unoff();
                break;
            }
            case 104: {
                this.Imp();
                this.PLA();
                break;
            }
            case 105: {
                this.Imm();
                this.ADC();
                break;
            }
            case 106: {
                this.Imp();
                this.ROR_A();
                break;
            }
            case 107: {
                this.Unoff();
                break;
            }
            case 108: {
                this.Ind();
                this.JMP();
                break;
            }
            case 109: {
                this.Abs();
                this.ADC();
                break;
            }
            case 110: {
                this.Abs();
                this.ROR();
                break;
            }
            case 111: {
                this.Unoff();
                break;
            }
            case 112: {
                this.Rel();
                this.BVS();
                break;
            }
            case 113: {
                this.IndZeroY();
                this.ADC();
                break;
            }
            case 114: {
                this.Hang();
                break;
            }
            case 115: {
                this.Unoff();
                break;
            }
            case 116: {
                this.Unoff2();
                break;
            }
            case 117: {
                this.ZeroX();
                this.ADC();
                break;
            }
            case 118: {
                this.ZeroX();
                this.ROR();
                break;
            }
            case 119: {
                this.Unoff();
                break;
            }
            case 120: {
                this.Imp();
                this.SEI();
                break;
            }
            case 121: {
                this.AbsY();
                this.ADC();
                break;
            }
            case 122: {
                this.Unoff1();
                break;
            }
            case 123: {
                this.Unoff();
                break;
            }
            case 124: {
                this.Unoff3();
                break;
            }
            case 125: {
                this.AbsX();
                this.ADC();
                break;
            }
            case 126: {
                this.WAbsX();
                this.ROR();
                break;
            }
            case 127: {
                this.Unoff();
                break;
            }
            case 128: {
                this.Unoff2();
                break;
            }
            case 129: {
                this.IndZeroX();
                this.STA();
                break;
            }
            case 130: {
                this.Unoff2();
                break;
            }
            case 131: {
                this.Unoff();
                break;
            }
            case 132: {
                this.Zero();
                this.STY();
                break;
            }
            case 133: {
                this.Zero();
                this.STA();
                break;
            }
            case 134: {
                this.Zero();
                this.STX();
                break;
            }
            case 135: {
                this.Unoff();
                break;
            }
            case 136: {
                this.Imp();
                this.DEY();
                break;
            }
            case 137: {
                this.Unoff2();
                break;
            }
            case 138: {
                this.Imp();
                this.TXA();
                break;
            }
            case 139: {
                this.Unoff();
                break;
            }
            case 140: {
                this.Abs();
                this.STY();
                break;
            }
            case 141: {
                this.Abs();
                this.STA();
                break;
            }
            case 142: {
                this.Abs();
                this.STX();
                break;
            }
            case 143: {
                this.Unoff();
                break;
            }
            case 144: {
                this.Rel();
                this.BCC();
                break;
            }
            case 145: {
                this.WIndZeroY();
                this.STA();
                break;
            }
            case 146: {
                this.Hang();
                break;
            }
            case 147: {
                this.Unoff();
                break;
            }
            case 148: {
                this.ZeroX();
                this.STY();
                break;
            }
            case 149: {
                this.ZeroX();
                this.STA();
                break;
            }
            case 150: {
                this.ZeroY();
                this.STX();
                break;
            }
            case 151: {
                this.Unoff();
                break;
            }
            case 152: {
                this.Imp();
                this.TYA();
                break;
            }
            case 153: {
                this.WAbsY();
                this.STA();
                break;
            }
            case 154: {
                this.Imp();
                this.TXS();
                break;
            }
            case 155: {
                this.Unoff();
                break;
            }
            case 156: {
                this.Unoff();
                break;
            }
            case 157: {
                this.WAbsX();
                this.STA();
                break;
            }
            case 158: {
                this.Unoff();
                break;
            }
            case 159: {
                this.Unoff();
                break;
            }
            case 160: {
                this.Imm();
                this.LDY();
                break;
            }
            case 161: {
                this.IndZeroX();
                this.LDA();
                break;
            }
            case 162: {
                this.Imm();
                this.LDX();
                break;
            }
            case 163: {
                this.Unoff();
                break;
            }
            case 164: {
                this.Zero();
                this.LDY();
                break;
            }
            case 165: {
                this.Zero();
                this.LDA();
                break;
            }
            case 166: {
                this.Zero();
                this.LDX();
                break;
            }
            case 167: {
                this.Unoff();
                break;
            }
            case 168: {
                this.Imp();
                this.TAY();
                break;
            }
            case 169: {
                this.Imm();
                this.LDA();
                break;
            }
            case 170: {
                this.Imp();
                this.TAX();
                break;
            }
            case 171: {
                this.Unoff();
                break;
            }
            case 172: {
                this.Abs();
                this.LDY();
                break;
            }
            case 173: {
                this.Abs();
                this.LDA();
                break;
            }
            case 174: {
                this.Abs();
                this.LDX();
                break;
            }
            case 175: {
                this.Unoff();
                break;
            }
            case 176: {
                this.Rel();
                this.BCS();
                break;
            }
            case 177: {
                this.IndZeroY();
                this.LDA();
                break;
            }
            case 178: {
                this.Hang();
                break;
            }
            case 179: {
                this.Unoff();
                break;
            }
            case 180: {
                this.ZeroX();
                this.LDY();
                break;
            }
            case 181: {
                this.ZeroX();
                this.LDA();
                break;
            }
            case 182: {
                this.ZeroY();
                this.LDX();
                break;
            }
            case 183: {
                this.Unoff();
                break;
            }
            case 184: {
                this.Imp();
                this.CLV();
                break;
            }
            case 185: {
                this.AbsY();
                this.LDA();
                break;
            }
            case 186: {
                this.Imp();
                this.TSX();
                break;
            }
            case 187: {
                this.Unoff();
                break;
            }
            case 188: {
                this.AbsX();
                this.LDY();
                break;
            }
            case 189: {
                this.AbsX();
                this.LDA();
                break;
            }
            case 190: {
                this.AbsY();
                this.LDX();
                break;
            }
            case 191: {
                this.Unoff();
                break;
            }
            case 192: {
                this.Imm();
                this.CPY();
                break;
            }
            case 193: {
                this.IndZeroX();
                this.CMP();
                break;
            }
            case 194: {
                this.Unoff2();
                break;
            }
            case 195: {
                this.Unoff();
                break;
            }
            case 196: {
                this.Zero();
                this.CPY();
                break;
            }
            case 197: {
                this.Zero();
                this.CMP();
                break;
            }
            case 198: {
                this.Zero();
                this.DEC();
                break;
            }
            case 199: {
                this.Unoff();
                break;
            }
            case 200: {
                this.Imp();
                this.INY();
                break;
            }
            case 201: {
                this.Imm();
                this.CMP();
                break;
            }
            case 202: {
                this.Imp();
                this.DEX();
                break;
            }
            case 203: {
                this.Unoff();
                break;
            }
            case 204: {
                this.Abs();
                this.CPY();
                break;
            }
            case 205: {
                this.Abs();
                this.CMP();
                break;
            }
            case 206: {
                this.Abs();
                this.DEC();
                break;
            }
            case 207: {
                this.Unoff();
                break;
            }
            case 208: {
                this.Rel();
                this.BNE();
                break;
            }
            case 209: {
                this.IndZeroY();
                this.CMP();
                break;
            }
            case 210: {
                this.Hang();
                break;
            }
            case 211: {
                this.Unoff();
                break;
            }
            case 212: {
                this.Unoff2();
                break;
            }
            case 213: {
                this.ZeroX();
                this.CMP();
                break;
            }
            case 214: {
                this.ZeroX();
                this.DEC();
                break;
            }
            case 215: {
                this.Unoff();
                break;
            }
            case 216: {
                this.Imp();
                this.CLD();
                break;
            }
            case 217: {
                this.AbsY();
                this.CMP();
                break;
            }
            case 218: {
                this.Unoff1();
                break;
            }
            case 219: {
                this.Unoff();
                break;
            }
            case 220: {
                this.Unoff3();
                break;
            }
            case 221: {
                this.AbsX();
                this.CMP();
                break;
            }
            case 222: {
                this.WAbsX();
                this.DEC();
                break;
            }
            case 223: {
                this.Unoff();
                break;
            }
            case 224: {
                this.Imm();
                this.CPX();
                break;
            }
            case 225: {
                this.IndZeroX();
                this.SBC();
                break;
            }
            case 226: {
                this.Unoff2();
                break;
            }
            case 227: {
                this.Unoff();
                break;
            }
            case 228: {
                this.Zero();
                this.CPX();
                break;
            }
            case 229: {
                this.Zero();
                this.SBC();
                break;
            }
            case 230: {
                this.Zero();
                this.INC();
                break;
            }
            case 231: {
                this.Unoff();
                break;
            }
            case 232: {
                this.Imp();
                this.INX();
                break;
            }
            case 233: {
                this.Imm();
                this.SBC();
                break;
            }
            case 234: {
                this.Imp();
                this.NOP();
                break;
            }
            case 235: {
                this.Imm();
                this.SBC();
                break;
            }
            case 236: {
                this.Abs();
                this.CPX();
                break;
            }
            case 237: {
                this.Abs();
                this.SBC();
                break;
            }
            case 238: {
                this.Abs();
                this.INC();
                break;
            }
            case 239: {
                this.Unoff();
                break;
            }
            case 240: {
                this.Rel();
                this.BEQ();
                break;
            }
            case 241: {
                this.IndZeroY();
                this.SBC();
                break;
            }
            case 242: {
                this.Hang();
                break;
            }
            case 243: {
                this.Unoff();
                break;
            }
            case 244: {
                this.Unoff2();
                break;
            }
            case 245: {
                this.ZeroX();
                this.SBC();
                break;
            }
            case 246: {
                this.ZeroX();
                this.INC();
                break;
            }
            case 247: {
                this.Unoff();
                break;
            }
            case 248: {
                this.Imp();
                this.SED();
                break;
            }
            case 249: {
                this.AbsY();
                this.SBC();
                break;
            }
            case 250: {
                this.Unoff1();
                break;
            }
            case 251: {
                this.Unoff();
                break;
            }
            case 252: {
                this.Unoff3();
                break;
            }
            case 253: {
                this.AbsX();
                this.SBC();
                break;
            }
            case 254: {
                this.WAbsX();
                this.INC();
                break;
            }
            case 255: {
                this.Unoff();
            }
        }
    }

    public int[] dumpState() {
        int[] state = new int[]{this.programCounter, this.getStatusRegisterByte(), this.accumulator, this.xRegister, this.yRegister, this.stackPointer};
        return state;
    }

    public void loadState(int[] state) {
        this.programCounter = state[0];
        this.setStatusRegisterByte(state[1]);
        this.accumulator = state[2];
        this.xRegister = state[3];
        this.yRegister = state[4];
        this.stackPointer = state[5];
    }

    private void setStatusRegisterByte(int statusRegister) {
        if ((statusRegister & 0x80) == 128) {
            this.N = true;
        }
        if ((statusRegister & 0x40) == 64) {
            this.V = true;
        }
        if ((statusRegister & 0x20) == 32) {
            this.M = true;
        }
        if ((statusRegister & 0x10) == 16) {
            this.B = true;
        }
        if ((statusRegister & 8) == 8) {
            this.D = true;
        }
        if ((statusRegister & 4) == 4) {
            this.I = true;
        }
        if ((statusRegister & 2) == 2) {
            this.Z = true;
        }
        if ((statusRegister & 1) == 1) {
            this.C = true;
        }
    }

    private void setStatusRegisterNZ(byte val) {
        this.N = val < 0;
        this.Z = val == 0;
    }

    private void setFlagCarry(int val) {
        this.C = (val & 0x100) != 0;
    }

    private void setFlagBorrow(int val) {
        this.C = (val & 0x100) == 0;
    }

    private int getStatusRegisterByte() {
        this.statusRegister = 0;
        if (this.N) {
            this.statusRegister |= 0x80;
        }
        if (this.V) {
            this.statusRegister |= 0x40;
        }
        if (this.M) {
            this.statusRegister |= 0x20;
        }
        if (this.B) {
            this.statusRegister |= 0x10;
        }
        if (this.D) {
            this.statusRegister |= 8;
        }
        if (this.I) {
            this.statusRegister |= 4;
        }
        if (this.Z) {
            this.statusRegister |= 2;
        }
        if (this.C) {
            this.statusRegister |= 1;
        }
        return this.statusRegister;
    }

    private void synchronize() {
        int realTimeMillis = (int)(System.currentTimeMillis() - this.lastTime);
        int sleepMillis = this.synchroMillis - realTimeMillis;
        if (sleepMillis < 0) {
            sleepMillis = 5;
        }
        try {
            Thread.sleep(sleepMillis);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.lastTime = System.currentTimeMillis();
    }

    private void Imp() {
        ++this.cycles;
    }

    private void Imm() {
        this.op = this.programCounter++;
    }

    private void Zero() {
        this.op = this.mem.read(this.programCounter++);
        ++this.cycles;
    }

    private void ZeroX() {
        this.op = this.mem.read(this.programCounter++) + this.xRegister & 0xFF;
        ++this.cycles;
    }

    private void ZeroY() {
        this.op = this.mem.read(this.programCounter++) + this.yRegister & 0xFF;
        ++this.cycles;
    }

    private void Abs() {
        this.op = this.memReadAbsolute(this.programCounter);
        this.programCounter += 2;
        this.cycles += 2;
    }

    private void AbsX() {
        this.opL = this.mem.read(this.programCounter++) + this.xRegister;
        this.opH = this.mem.read(this.programCounter++) << 8;
        this.cycles += 2;
        if (this.opL >= 256) {
            ++this.cycles;
        }
        this.op = this.opH + this.opL;
    }

    private void AbsY() {
        this.opL = this.mem.read(this.programCounter++) + this.yRegister;
        this.opH = this.mem.read(this.programCounter++) << 8;
        this.cycles += 2;
        if (this.opL >= 256) {
            ++this.cycles;
        }
        this.op = this.opH + this.opL;
    }

    private void Ind() {
        this.ptrL = this.mem.read(this.programCounter++);
        this.ptrH = this.mem.read(this.programCounter++) << 8;
        this.op = this.mem.read(this.ptrH + this.ptrL);
        this.ptrL = this.ptrL + 1 & 0xFF;
        this.op += this.mem.read(this.ptrH + this.ptrL) << 8;
        this.cycles += 4;
    }

    private void IndZeroX() {
        this.ptr = this.xRegister + this.mem.read(this.programCounter++);
        this.op = this.mem.read(this.ptr);
        this.op += this.mem.read(this.ptr + 1 & 0xFF) << 8;
        this.cycles += 3;
    }

    private void IndZeroY() {
        this.ptr = this.mem.read(this.programCounter++);
        this.opL = this.mem.read(this.ptr) + this.yRegister;
        this.opH = (this.mem.read(this.ptr + 1) & 0xFF) << 8;
        this.cycles += 3;
        if (this.opL >= 256) {
            ++this.cycles;
        }
        this.op = this.opH + this.opL;
    }

    private void Rel() {
        this.op = this.mem.read(this.programCounter++);
        if (this.op >= 128) {
            this.op = -(256 - this.op);
        }
        this.op = this.op + this.programCounter & 0xFFFF;
        ++this.cycles;
    }

    private void WAbsX() {
        this.opL = this.mem.read(this.programCounter++) + this.xRegister;
        this.opH = this.mem.read(this.programCounter++) << 8;
        this.cycles += 3;
        this.op = this.opH + this.opL;
    }

    private void WAbsY() {
        this.opL = this.mem.read(this.programCounter++) + this.yRegister;
        this.opH = this.mem.read(this.programCounter++) << 8;
        this.cycles += 3;
        this.op = this.opH + this.opL;
    }

    private void WIndZeroY() {
        this.ptr = this.mem.read(this.programCounter++);
        this.opL = this.mem.read(this.ptr) + this.yRegister;
        this.opH = this.mem.read(this.ptr + 1 & 0xFF) << 8;
        this.cycles += 4;
        this.op = this.opH + this.opL;
    }

    private void LDA() {
        this.accumulator = this.mem.read(this.op);
        this.setStatusRegisterNZ((byte)this.accumulator);
        ++this.cycles;
    }

    private void LDX() {
        this.xRegister = this.mem.read(this.op);
        this.setStatusRegisterNZ((byte)this.xRegister);
        ++this.cycles;
    }

    private void LDY() {
        this.yRegister = this.mem.read(this.op);
        this.setStatusRegisterNZ((byte)this.yRegister);
        ++this.cycles;
    }

    private void STA() {
        this.mem.write(this.op, this.accumulator & 0xFF);
        ++this.cycles;
    }

    private void STX() {
        this.mem.write(this.op, this.xRegister & 0xFF);
        ++this.cycles;
    }

    private void STY() {
        this.mem.write(this.op, this.yRegister & 0xFF);
        ++this.cycles;
    }

    private void ADC() {
        int Op1 = this.accumulator;
        int Op2 = this.mem.read(this.op);
        ++this.cycles;
        if (this.D) {
            this.Z = (Op1 + Op2 + (this.C ? 1 : 0) & 0xFF) == 0;
            this.tmp = (Op1 & 0xF) + (Op2 & 0xF) + (this.C ? 1 : 0);
            this.accumulator = this.tmp < 10 ? this.tmp : this.tmp + 6;
            this.tmp = (Op1 & 0xF0) + (Op2 & 0xF0) + (this.tmp & 0xF0);
            this.N = (byte)this.tmp < 0;
            this.V = ((Op1 ^ this.tmp) & ~(Op1 ^ Op2) & 0x80) != 0;
            this.tmp = this.accumulator & 0xF | (this.tmp < 160 ? this.tmp : this.tmp + 96);
            this.C = this.tmp >= 256;
            this.accumulator = this.tmp & 0xFF;
        } else {
            this.tmp = Op1 + Op2 + (this.C ? 1 : 0);
            this.accumulator = this.tmp & 0xFF;
            this.V = ((Op1 ^ this.accumulator) & ~(Op1 ^ Op2) & 0x80) != 0;
            this.setFlagCarry(this.tmp);
            this.setStatusRegisterNZ((byte)this.accumulator);
        }
    }

    private void SBC() {
        int Op1 = this.accumulator;
        int Op2 = this.mem.read(this.op);
        ++this.cycles;
        if (this.D) {
            this.tmp = (Op1 & 0xF) - (Op2 & 0xF) - (this.C ? 0 : 1);
            this.accumulator = (this.tmp & 0x10) == 0 ? this.tmp : this.tmp - 6;
            this.tmp = (Op1 & 0xF0) - (Op2 & 0xF0) - (this.accumulator & 0x10);
            this.accumulator = this.accumulator & 0xF | ((this.tmp & 0x100) == 0 ? this.tmp : this.tmp - 96);
            this.tmp = Op1 - Op2 - (this.C ? 0 : 1);
            this.setFlagBorrow(this.tmp);
            this.setStatusRegisterNZ((byte)this.tmp);
        } else {
            this.tmp = Op1 - Op2 - (this.C ? 0 : 1);
            this.accumulator = this.tmp & 0xFF;
            this.V = ((Op1 ^ Op2) & (Op1 ^ this.accumulator) & 0x80) != 0;
            this.setFlagBorrow(this.tmp);
            this.setStatusRegisterNZ((byte)this.accumulator);
        }
    }

    private void CMP() {
        this.tmp = this.accumulator - this.mem.read(this.op);
        ++this.cycles;
        this.setFlagBorrow(this.tmp);
        this.setStatusRegisterNZ((byte)this.tmp);
    }

    private void CPX() {
        this.tmp = this.xRegister - this.mem.read(this.op);
        ++this.cycles;
        this.setFlagBorrow(this.tmp);
        this.setStatusRegisterNZ((byte)this.tmp);
    }

    private void CPY() {
        this.tmp = this.yRegister - this.mem.read(this.op);
        ++this.cycles;
        this.setFlagBorrow(this.tmp);
        this.setStatusRegisterNZ((byte)this.tmp);
    }

    private void AND() {
        this.accumulator &= this.mem.read(this.op) & 0xFF;
        ++this.cycles;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void ORA() {
        this.accumulator |= this.mem.read(this.op) & 0xFF;
        ++this.cycles;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void EOR() {
        this.accumulator ^= this.mem.read(this.op) & 0xFF;
        ++this.cycles;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void ASL() {
        this.btmp = (byte)(this.mem.read(this.op) & 0xFF);
        this.mem.write(this.op, this.btmp);
        this.C = this.btmp < 0;
        this.btmp = (byte)(this.btmp << 1);
        this.setStatusRegisterNZ(this.btmp);
        this.mem.write(this.op, this.btmp & 0xFF);
        this.cycles += 3;
    }

    private void ASL_A() {
        this.tmp = this.accumulator << 1;
        this.accumulator = this.tmp & 0xFF;
        this.setFlagCarry(this.tmp);
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void LSR() {
        this.btmp = (byte)(this.mem.read(this.op) & 0xFF);
        this.cycles += 2;
        this.C = (this.btmp & 1) != 0;
        this.btmp = (byte)((this.btmp & 0xFF) >> 1);
        this.setStatusRegisterNZ(this.btmp);
        this.mem.write(this.op, this.btmp & 0xFF);
        ++this.cycles;
    }

    private void LSR_A() {
        this.C = (this.accumulator & 1) != 0;
        this.accumulator >>= 1;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void ROL() {
        this.btmp = (byte)(this.mem.read(this.op) & 0xFF);
        this.cycles += 2;
        boolean newCarry = this.btmp < 0;
        this.btmp = (byte)((this.btmp & 0xFF) << 1 | (this.C ? 1 : 0));
        this.C = newCarry;
        this.setStatusRegisterNZ(this.btmp);
        this.mem.write(this.op, this.btmp & 0xFF);
        ++this.cycles;
    }

    private void ROL_A() {
        this.tmp = this.accumulator << 1 | (this.C ? 1 : 0);
        this.accumulator = this.tmp & 0xFF;
        this.setFlagCarry(this.tmp);
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void ROR() {
        this.btmp = (byte)(this.mem.read(this.op) & 0xFF);
        this.cycles += 2;
        boolean newCarry = (this.btmp & 1) != 0;
        this.btmp = (byte)((this.btmp & 0xFF) >> 1 | (this.C ? 128 : 0));
        this.C = newCarry;
        this.setStatusRegisterNZ(this.btmp);
        this.mem.write(this.op, this.btmp & 0xFF);
        ++this.cycles;
    }

    private void ROR_A() {
        this.tmp = this.accumulator | (this.C ? 256 : 0);
        this.C = (this.accumulator & 1) != 0;
        this.accumulator = this.tmp >> 1;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void INC() {
        this.btmp = (byte)(this.mem.read(this.op) & 0xFF);
        this.mem.write(this.op, this.btmp);
        this.btmp = (byte)(this.btmp + 1);
        this.setStatusRegisterNZ(this.btmp);
        this.mem.write(this.op, this.btmp & 0xFF);
        this.cycles += 2;
    }

    private void DEC() {
        this.btmp = (byte)(this.mem.read(this.op) & 0xFF);
        this.mem.write(this.op, this.btmp);
        this.btmp = (byte)(this.btmp - 1);
        this.setStatusRegisterNZ(this.btmp);
        this.mem.write(this.op, this.btmp & 0xFF);
        this.cycles += 2;
    }

    private void INX() {
        this.xRegister = this.xRegister + 1 & 0xFF;
        this.setStatusRegisterNZ((byte)this.xRegister);
    }

    private void INY() {
        this.yRegister = this.yRegister + 1 & 0xFF;
        this.setStatusRegisterNZ((byte)this.yRegister);
    }

    private void DEX() {
        this.xRegister = this.xRegister - 1 & 0xFF;
        this.setStatusRegisterNZ((byte)this.xRegister);
    }

    private void DEY() {
        this.yRegister = this.yRegister - 1 & 0xFF;
        this.setStatusRegisterNZ((byte)this.yRegister);
    }

    private void BIT() {
        this.btmp = (byte)(this.mem.read(this.op) & 0xFF);
        this.V = (this.btmp & 0x40) != 0;
        this.N = this.btmp < 0;
        this.Z = (this.btmp & this.accumulator) == 0;
        ++this.cycles;
    }

    private void PHA() {
        this.mem.write(256 + this.stackPointer, this.accumulator & 0xFF);
        this.stackPointer = this.stackPointer - 1 & 0xFF;
        ++this.cycles;
    }

    private void PHP() {
        this.statusRegister = this.getStatusRegisterByte();
        this.mem.write(256 + this.stackPointer, this.statusRegister & 0xFF);
        this.stackPointer = this.stackPointer - 1 & 0xFF;
        ++this.cycles;
    }

    private void PLA() {
        this.mem.read(this.stackPointer + 256);
        this.stackPointer = this.stackPointer + 1 & 0xFF;
        this.accumulator = this.mem.read(this.stackPointer + 256) & 0xFF;
        this.setStatusRegisterNZ((byte)this.accumulator);
        this.cycles += 2;
    }

    private void PLP() {
        this.mem.read(this.stackPointer + 256);
        this.stackPointer = this.stackPointer + 1 & 0xFF;
        this.statusRegister = this.mem.read(this.stackPointer + 256) & 0xFF;
        this.setStatusRegisterByte(this.statusRegister);
        this.cycles += 2;
    }

    private void BRK() {
        this.mem.read(this.op);
        this.pushProgramCounter();
        this.PHP();
        this.I = true;
        this.programCounter = this.memReadAbsolute(65534);
        this.cycles += 3;
    }

    private void RTI() {
        this.mem.read(this.stackPointer + 256);
        this.PLP();
        this.popProgramCounter();
        ++this.cycles;
    }

    private void JMP() {
        this.programCounter = this.op;
    }

    private void RTS() {
        this.mem.read(this.stackPointer + 256);
        this.popProgramCounter();
        this.mem.read(this.programCounter++);
        this.cycles += 2;
    }

    private void JSR() {
        this.opL = this.mem.read(this.programCounter++) & 0xFF;
        this.mem.read(this.stackPointer + 256);
        this.pushProgramCounter();
        this.programCounter = this.opL + ((this.mem.read(this.programCounter) & 0xFF) << 8);
        this.cycles += 3;
    }

    private void branch() {
        ++this.cycles;
        if ((this.programCounter & 0xFF00) != (this.op & 0xFF00)) {
            ++this.cycles;
        }
        this.programCounter = this.op;
    }

    private void BNE() {
        if (!this.Z) {
            this.branch();
        }
    }

    private void BEQ() {
        if (this.Z) {
            this.branch();
        }
    }

    private void BVC() {
        if (!this.V) {
            this.branch();
        }
    }

    private void BVS() {
        if (this.V) {
            this.branch();
        }
    }

    private void BCC() {
        if (!this.C) {
            this.branch();
        }
    }

    private void BCS() {
        if (this.C) {
            this.branch();
        }
    }

    private void BPL() {
        if (!this.N) {
            this.branch();
        }
    }

    private void BMI() {
        if (this.N) {
            this.branch();
        }
    }

    private void TAX() {
        this.xRegister = this.accumulator;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void TXA() {
        this.accumulator = this.xRegister;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void TAY() {
        this.yRegister = this.accumulator;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void TYA() {
        this.accumulator = this.yRegister;
        this.setStatusRegisterNZ((byte)this.accumulator);
    }

    private void TXS() {
        this.stackPointer = this.xRegister;
    }

    private void TSX() {
        this.xRegister = this.stackPointer;
        this.setStatusRegisterNZ((byte)this.xRegister);
    }

    private void CLC() {
        this.C = false;
    }

    private void SEC() {
        this.C = true;
    }

    private void CLI() {
        this.I = false;
    }

    private void SEI() {
        this.I = true;
    }

    private void CLV() {
        this.V = false;
    }

    private void CLD() {
        this.D = false;
    }

    private void SED() {
        this.D = true;
    }

    private void NOP() {
    }

    private void Unoff() {
    }

    private void Unoff1() {
    }

    private void Unoff2() {
        ++this.programCounter;
    }

    private void Unoff3() {
        this.programCounter += 2;
    }

    private void Hang() {
        --this.programCounter;
    }

    private void handleIRQ() {
        this.pushProgramCounter();
        this.mem.write(256 + this.stackPointer, (byte)(this.getStatusRegisterByte() & 0xFFFFFFEF));
        --this.stackPointer;
        this.I = true;
        this.programCounter = this.memReadAbsolute(65534);
        this.cycles += 8;
    }

    private void handleNMI() {
        this.pushProgramCounter();
        this.mem.write(256 + this.stackPointer, (byte)(this.getStatusRegisterByte() & 0xFFFFFFEF));
        --this.stackPointer;
        this.I = true;
        this.NMI = false;
        this.programCounter = this.memReadAbsolute(65530);
        this.cycles += 8;
    }

    private int memReadAbsolute(int adr) {
        return this.mem.read(adr) | (this.mem.read(adr + 1) & 0xFF) << 8;
    }

    private void pushProgramCounter() {
        this.mem.write(this.stackPointer + 256, (byte)(this.programCounter >> 8));
        this.stackPointer = this.stackPointer - 1 & 0xFF;
        this.mem.write(this.stackPointer + 256, (byte)this.programCounter);
        this.stackPointer = this.stackPointer - 1 & 0xFF;
        this.cycles += 2;
    }

    private void popProgramCounter() {
        this.stackPointer = this.stackPointer + 1 & 0xFF;
        this.programCounter = this.mem.read(this.stackPointer + 256) & 0xFF;
        this.stackPointer = this.stackPointer + 1 & 0xFF;
        this.programCounter += (this.mem.read(this.stackPointer + 256) & 0xFF) << 8;
        this.cycles += 2;
    }
}

